/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager.queue;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class ListenableQueue<E>
extends AbstractQueue<E> {
    private static final Object lock = new Object();
    private final Queue<E> delegate;
    private final List<Listener<E>> listeners = new ArrayList<Listener<E>>();

    public ListenableQueue(Queue<E> delegate) {
        this.delegate = delegate;
    }

    public ListenableQueue<E> registerListener(Listener<E> listener) {
        this.listeners.add(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (this.delegate.offer(e)) {
            Object object = lock;
            synchronized (object) {
                lock.notify();
                this.listeners.forEach(listener -> listener.onElementAdded(e));
            }
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        return this.delegate.poll();
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    static interface Listener<E> {
        public void onElementAdded(E var1);
    }
}

