/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager.pdc;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.storagemanager.CacheManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.storageproviders.HoneypotStore;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

@HoneypotStore(name="pdc")
public class DataStoreManager
extends StorageProvider {
    final Honeypot plugin;
    private final HoneypotLogger logger;

    @Inject
    public DataStoreManager(Honeypot plugin, HoneypotLogger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    @Override
    public void createHoneypotBlock(Block block, String action) {
        block.getWorld().getPersistentDataContainer().set(this.formatKey(block), PersistentDataType.STRING, (Object)action);
    }

    @Override
    public void removeHoneypotBlock(Block block) {
        block.getWorld().getPersistentDataContainer().remove(this.formatKey(block));
    }

    @Override
    public boolean isHoneypotBlock(Block block) {
        return block.getWorld().getPersistentDataContainer().has(this.formatKey(block));
    }

    public NamespacedKey formatKey(Block block) {
        String coordinates = block.getX() + "_" + block.getY() + "_" + block.getZ();
        return new NamespacedKey((Plugin)this.plugin, "honeypot-container-" + coordinates);
    }

    @Override
    public HoneypotBlockObject getHoneypotBlock(Block block) {
        return this.isHoneypotBlock(block) ? new HoneypotBlockObject(block, this.getAction(block)) : null;
    }

    @Override
    public String getAction(Block block) {
        return (String)block.getWorld().getPersistentDataContainer().get(this.formatKey(block), PersistentDataType.STRING);
    }

    @Override
    public void deleteAllHoneypotBlocks(@Nullable World world) {
        Set keys = world.getPersistentDataContainer().getKeys();
        for (NamespacedKey key : keys) {
            if (!key.getKey().startsWith("honeypot-container-")) continue;
            world.getPersistentDataContainer().remove(key);
        }
        CacheManager.clearCache();
        this.logger.debug((Component)Component.text((String)"Deleted all Honeypot blocks!"));
    }

    @Override
    public List<HoneypotBlockObject> getAllHoneypots(World world) {
        ArrayList<HoneypotBlockObject> blocks = new ArrayList<HoneypotBlockObject>();
        Set keys = world.getPersistentDataContainer().getKeys();
        for (NamespacedKey key : keys) {
            if (!key.getKey().startsWith("honeypot-container-")) continue;
            String coordinatesRaw = key.getKey().split("honeypot-container-")[1];
            String coordinates = coordinatesRaw.replace("_", ", ");
            blocks.add(new HoneypotBlockObject(world.getName(), coordinates, (String)world.getPersistentDataContainer().get(key, PersistentDataType.STRING)));
        }
        return blocks;
    }

    @Override
    public List<HoneypotBlockObject> getNearbyHoneypots(Location location, int radius) {
        ArrayList<HoneypotBlockObject> honeypots = new ArrayList<HoneypotBlockObject>();
        for (HoneypotBlockObject honeypot : this.getAllHoneypots(location.getWorld())) {
            if (!(honeypot.getLocation().distance(location) <= (double)radius)) continue;
            honeypots.add(honeypot);
        }
        return honeypots;
    }
}

