/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.common.storagemanager.sqlite.SQLite;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class HoneypotPlayerManager {
    private final HoneypotLogger logger;
    private final SQLite db;

    @Inject
    public HoneypotPlayerManager(HoneypotLogger logger, SQLite db) {
        this.logger = logger;
        this.db = db;
    }

    public void addPlayer(Player player, int blocksBroken) {
        this.db.createHoneypotPlayer(player, blocksBroken);
        this.logger.info((Component)Component.text((String)("Create Honeypot player: " + player.getName() + ", UUID of: " + String.valueOf(player.getUniqueId()))));
    }

    public void setPlayerCount(Player player, int blocksBroken) {
        this.db.setPlayerCount(player, blocksBroken);
        this.logger.debug((Component)Component.text((String)("Updated Honeypot player: " + player.getName() + ", UUID of: " + String.valueOf(player.getUniqueId()) + ". New count: " + blocksBroken)));
    }

    public int getCount(Player player) {
        return this.db.getCount(player);
    }

    public int getCount(OfflinePlayer player) {
        return this.db.getCount(player);
    }

    public void deleteAllHoneypotPlayers() {
        this.db.deleteAllPlayers();
        this.logger.debug((Component)Component.text((String)"Deleted all Honeypot players from DB"));
    }
}

