/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager;

import com.google.inject.Inject;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.common.storagemanager.sqlite.SQLite;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.storageproviders.HoneypotPlayerHistoryObject;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class HoneypotPlayerHistoryManager {
    private final HoneypotLogger logger;
    private final SQLite db;

    @Inject
    public HoneypotPlayerHistoryManager(HoneypotLogger logger, SQLite db) {
        this.logger = logger;
        this.db = db;
    }

    public void addPlayerHistory(Player p, HoneypotBlockObject b, String type) {
        this.db.addPlayerHistory(p, b, type);
        this.logger.debug((Component)Component.text((String)("Added new history entry for player " + p.getName())));
    }

    public List<HoneypotPlayerHistoryObject> getPlayerHistory(Player p) {
        return this.db.retrieveHistory(p);
    }

    public void deletePlayerHistory(Player p, int ... n) {
        if (n.length > 0) {
            this.db.deletePlayerHistory(p, n);
        } else {
            this.db.deletePlayerHistory(p, new int[0]);
        }
        this.logger.debug((Component)Component.text((String)("Deleting player history for player " + p.getName())));
    }

    public void deleteAllHistory() {
        this.db.deleteAllHistory();
    }
}

