/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.storagemanager.CacheManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class HoneypotBlockManager {
    @Inject
    private HoneypotLogger logger;
    @Inject
    private CacheManager cacheManager;

    public void createBlock(Block block, String action) {
        Registry.getStorageProvider().createHoneypotBlock(block, action);
        this.cacheManager.addToCache(new HoneypotBlockObject(block, action));
        this.logger.debug((Component)Component.text((String)("Created Honeypot block with action " + action + " at " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
    }

    public void deleteBlock(Block block) {
        Optional<Block> matched = this.resolveLogicalBlocks(block).filter(b -> Registry.getStorageProvider().isHoneypotBlock((Block)b)).findFirst();
        if (matched.isEmpty()) {
            return;
        }
        Registry.getStorageProvider().removeHoneypotBlock(matched.get());
        this.cacheManager.removeFromCache(new HoneypotBlockObject(matched.get(), null));
        this.logger.debug((Component)Component.text((String)("Deleted Honeypot block with at " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
    }

    public boolean isHoneypotBlock(Block block) {
        if (this.cacheManager.isInCache(new HoneypotBlockObject(block, null)) != null) {
            return true;
        }
        Optional<Block> matched = this.resolveLogicalBlocks(block).filter(b -> Registry.getStorageProvider().isHoneypotBlock((Block)b)).findFirst();
        if (matched.isEmpty()) {
            return false;
        }
        String action = this.getAction(matched.get());
        this.cacheManager.addToCache(new HoneypotBlockObject(matched.get(), action));
        return true;
    }

    private Stream<Block> resolveLogicalBlocks(Block block) {
        Chest chest;
        BlockState blockState = block.getState();
        if (blockState instanceof Chest && (blockState = (chest = (Chest)blockState).getInventory().getHolder()) instanceof DoubleChest) {
            DoubleChest dc = (DoubleChest)blockState;
            return Stream.of(((Chest)dc.getLeftSide()).getBlock(), ((Chest)dc.getRightSide()).getBlock());
        }
        BlockData data = block.getBlockData();
        if (data instanceof Bed) {
            Bed bed = (Bed)data;
            BlockFace facing = bed.getFacing();
            Block other = bed.getPart() == Bed.Part.FOOT ? block.getRelative(facing) : block.getRelative(facing.getOppositeFace());
            return Stream.of(block, other);
        }
        if (data instanceof Door) {
            Door door = (Door)data;
            Block other = door.getHalf() == Bisected.Half.BOTTOM ? block.getRelative(BlockFace.UP) : block.getRelative(BlockFace.DOWN);
            return Stream.of(block, other);
        }
        return Stream.of(block);
    }

    public HoneypotBlockObject getHoneypotBlock(Block block) {
        if (this.isHoneypotBlock(block)) {
            return new HoneypotBlockObject(block, this.getAction(block));
        }
        return null;
    }

    public String getAction(Block block) {
        HoneypotBlockObject potential = this.cacheManager.isInCache(new HoneypotBlockObject(block, null));
        if (potential != null) {
            return potential.getAction();
        }
        try {
            Optional<Block> matched = this.resolveLogicalBlocks(block).filter(b -> Registry.getStorageProvider().isHoneypotBlock((Block)b)).findFirst();
            if (matched.isEmpty()) {
                throw new Exception("No action found");
            }
            return Registry.getStorageProvider().getAction(matched.get());
        }
        catch (Exception e) {
            this.logger.warning(Component.text((String)"No action found for block, this is likely due to a container being created using the special lock format. This is only possible with commands, as Anvil's are not able to support strings that long.Honeypot assumes these are Honeypots for performance. This can be safely ignored, but you need to investigate the block at: ").append((Component)Component.text((String)(block.getX() + ", " + block.getY() + ", " + block.getZ()))));
            return null;
        }
    }

    public void deleteAllHoneypotBlocks(World world) {
        Registry.getStorageProvider().deleteAllHoneypotBlocks(world);
        CacheManager.clearCache();
        this.logger.debug((Component)Component.text((String)"Deleted all Honeypot blocks!"));
    }

    public List<HoneypotBlockObject> getAllHoneypots(World world) {
        return Registry.getStorageProvider().getAllHoneypots(world);
    }
}

