/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

@Singleton
public class CacheManager {
    private static final List<HoneypotBlockObject> cache = new ArrayList<HoneypotBlockObject>();
    @Inject
    private HoneypotConfigManager configManager;
    @Inject
    private HoneypotLogger logger;

    public void addToCache(HoneypotBlockObject block) {
        int cacheSize = this.configManager.getPluginConfig().getInt("cache-size");
        if (cacheSize <= 0) {
            return;
        }
        if (cache.size() <= cacheSize) {
            cache.add(block);
        } else {
            cache.removeFirst();
            cache.add(block);
        }
    }

    public boolean removeFromCache(HoneypotBlockObject block) {
        return cache.removeIf(block::equals);
    }

    public HoneypotBlockObject isInCache(HoneypotBlockObject block) {
        for (HoneypotBlockObject b : cache) {
            if (!block.equals(b)) continue;
            return b;
        }
        return null;
    }

    public static void clearCache() {
        cache.clear();
    }

    @Generated
    public static List<HoneypotBlockObject> getCache() {
        return cache;
    }
}

