/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.providers.included;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.providers.Behavior;
import org.reprogle.honeypot.common.providers.BehaviorProvider;
import org.reprogle.honeypot.common.providers.BehaviorType;

@Behavior(type=BehaviorType.NOTIFY, name="notify", icon=Material.BEACON)
public class Notify
extends BehaviorProvider {
    @Inject
    private CommandFeedback commandFeedback;
    @Inject
    private Honeypot plugin;

    @Override
    public boolean process(Player p, Block block) {
        Component chatPrefix = this.commandFeedback.getChatPrefix();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("honeypot.notify") && !player.hasPermission("honeypot.*") && !player.isOp()) continue;
            player.sendMessage(chatPrefix.append((Component)Component.text((String)p.getName(), (TextColor)NamedTextColor.RED)).append((Component)Component.text((String)(" was caught breaking a Honeypot block at x=" + block.getX()))).append((Component)Component.text((String)(", y=" + block.getY()))).append((Component)Component.text((String)(", z=" + block.getZ()))).append((Component)Component.text((String)(" in world " + block.getWorld().getName()))));
        }
        this.plugin.getServer().getConsoleSender().sendMessage(chatPrefix.append((Component)Component.text((String)p.getName(), (TextColor)NamedTextColor.RED)).append((Component)Component.text((String)" was caught breaking a Honeypot block")));
        return true;
    }
}

