/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.providers;

import com.google.common.base.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.common.providers.Behavior;
import org.reprogle.honeypot.common.providers.BehaviorType;

public abstract class BehaviorProvider {
    protected final String providerName = this.getClass().getAnnotation(Behavior.class).name();
    protected final BehaviorType behaviorType = this.getClass().getAnnotation(Behavior.class).type();
    protected final Material icon = this.getClass().getAnnotation(Behavior.class).icon();

    protected BehaviorProvider() {
    }

    public String getProviderName() {
        return this.providerName;
    }

    public BehaviorType getBehaviorType() {
        return this.behaviorType;
    }

    public Material getIcon() {
        return this.icon;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BehaviorProvider)) {
            return false;
        }
        BehaviorProvider behavior = (BehaviorProvider)o;
        if (o == this) {
            return true;
        }
        return behavior.getProviderName().equals(this.providerName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.providerName, this.behaviorType, this.icon});
    }

    public abstract boolean process(Player var1, Block var2);
}

