/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.StructureGrowEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class StructureGrowEventListener
implements Listener {
    private final HoneypotBlockManager blockManager;
    private final HoneypotLogger logger;

    @Inject
    StructureGrowEventListener(HoneypotBlockManager blockManager, HoneypotLogger logger) {
        this.blockManager = blockManager;
        this.logger = logger;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onStructureGrowEvent(StructureGrowEvent event) {
        for (int i = 0; i < event.getBlocks().size(); ++i) {
            BlockState block = (BlockState)event.getBlocks().get(i);
            if (!this.blockManager.isHoneypotBlock(block.getBlock())) continue;
            this.logger.debug((Component)Component.text((String)("StuctureGrowEvent being cancelled for Honeypot located at " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            event.setCancelled(true);
        }
    }
}

