/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;

public class SignChangeEventListener
implements Listener {
    private final HoneypotBlockManager blockManager;
    private final HoneypotLogger logger;
    private final AdapterManager adapterManager;

    @Inject
    SignChangeEventListener(HoneypotBlockManager blockManager, HoneypotLogger logger, AdapterManager adapterManager) {
        this.blockManager = blockManager;
        this.logger = logger;
        this.adapterManager = adapterManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignChangeEvent(SignChangeEvent event) {
        Block block = event.getBlock();
        if (this.blockManager.isHoneypotBlock(block)) {
            if (!this.adapterManager.checkAllAdapters(event.getPlayer(), event.getBlock().getLocation())) {
                return;
            }
            this.logger.debug((Component)Component.text((String)("SignChangeEvent being called for Honeypot: " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            event.setCancelled(true);
        }
    }
}

