/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.HoneypotUpdateChecker;

public class PlayerJoinEventListener
implements Listener {
    private final CommandFeedback commandFeedback;
    private final HoneypotLogger logger;
    private final Honeypot plugin;

    @Inject
    PlayerJoinEventListener(Honeypot plugin, CommandFeedback commandFeedback, HoneypotLogger logger) {
        this.plugin = plugin;
        this.commandFeedback = commandFeedback;
        this.logger = logger;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void playerJoinEvent(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (p.hasPermission("honeypot.update") || p.hasPermission("honeypot.*") || p.isOp()) {
            new HoneypotUpdateChecker((Plugin)this.plugin, "https://raw.githubusercontent.com/TerrorByteTW/Honeypot/master/version.txt").getVersion(latest -> {
                if (Integer.parseInt(latest.replace(".", "")) > Integer.parseInt(this.plugin.getPluginMeta().getVersion().replace(".", ""))) {
                    Component message = this.commandFeedback.sendCommandFeedback("update-available", new Boolean[0]).clickEvent(ClickEvent.openUrl((String)"https://github.com/TerrorByteTW/Honeypot")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click me to download the latest update!")));
                    p.sendMessage(message);
                }
            }, this.logger);
        }
    }
}

