/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.reprogle.honeypot.api.events.HoneypotPlayerInteractEvent;
import org.reprogle.honeypot.api.events.HoneypotPrePlayerInteractEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.ActionHandler;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;

public class PlayerInteractEventListener
implements Listener {
    private final HoneypotConfigManager configManager;
    private final HoneypotBlockManager blockManager;
    private final HoneypotLogger logger;
    private final ActionHandler actionHandler;
    private final AdapterManager adapterManager;

    @Inject
    PlayerInteractEventListener(HoneypotConfigManager configManager, HoneypotBlockManager blockManager, HoneypotLogger logger, ActionHandler actionHandler, AdapterManager adapterManager) {
        this.configManager = configManager;
        this.blockManager = blockManager;
        this.logger = logger;
        this.actionHandler = actionHandler;
        this.adapterManager = adapterManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void playerInteractEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player.getTargetBlockExact(5) == null) {
            return;
        }
        if (!(player.getTargetBlockExact(5).getState() instanceof Container)) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block block = player.getTargetBlockExact(5);
        if (this.configManager.getPluginConfig().getBoolean("filters.inventories").booleanValue()) {
            List allowedBlocks = this.configManager.getPluginConfig().getList("allowed-inventories");
            boolean allowed = false;
            for (String blockType : allowedBlocks) {
                if (!Objects.requireNonNull(block).getType().name().equals(blockType)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        try {
            if (!Objects.requireNonNull(block).getType().equals((Object)Material.ENDER_CHEST) && this.blockManager.isHoneypotBlock(Objects.requireNonNull(block))) {
                if (!this.adapterManager.checkAllAdapters(player, Objects.requireNonNull(player.getTargetBlockExact(5)).getLocation())) {
                    return;
                }
                HoneypotPrePlayerInteractEvent hppie = new HoneypotPrePlayerInteractEvent(player, event.getClickedBlock());
                Bukkit.getPluginManager().callEvent((Event)hppie);
                if (hppie.isCancelled()) {
                    return;
                }
                if (!(player.hasPermission("honeypot.exempt") || player.hasPermission("honeypot.*") || player.isOp())) {
                    if (!this.configManager.getPluginConfig().getBoolean("always-allow-container-access").booleanValue()) {
                        event.setCancelled(true);
                    }
                    this.executeAction(event);
                }
                HoneypotPlayerInteractEvent hpie = new HoneypotPlayerInteractEvent(player, event.getClickedBlock());
                Bukkit.getPluginManager().callEvent((Event)hpie);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void executeAction(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = player.getTargetBlockExact(5);
        assert (block != null);
        String action = this.blockManager.getAction(block);
        if (action == null) {
            this.logger.debug((Component)Component.text((String)("A PlayerInteractEvent was called for player: " + player.getName() + ", UUID of " + String.valueOf(player.getUniqueId()) + ". However, the action was null, so this must be a FAKE HONEYPOT. Please investigate the block at " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            return;
        }
        this.logger.debug((Component)Component.text((String)("PlayerInteractEvent being called for player: " + player.getName() + ", UUID of " + String.valueOf(player.getUniqueId()) + ". Action is: " + action)));
        this.actionHandler.handleCustomAction(action, block, player);
    }
}

