/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.reprogle.honeypot.api.events.HoneypotNonPlayerBreakEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class PistonExtendRetractListener
implements Listener {
    private final HoneypotBlockManager blockManager;
    private final HoneypotLogger logger;

    @Inject
    PistonExtendRetractListener(HoneypotBlockManager blockManager, HoneypotLogger logger) {
        this.blockManager = blockManager;
        this.logger = logger;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void pistonPushEvent(BlockPistonExtendEvent event) {
        List blocks = event.getBlocks();
        for (Block b : blocks) {
            if (!this.blockManager.isHoneypotBlock(b)) continue;
            this.logger.debug((Component)Component.text((String)("PistonExtendEvent being called for Honeypot: " + b.getX() + ", " + b.getY() + "," + b.getZ())));
            HoneypotNonPlayerBreakEvent hnpbe = new HoneypotNonPlayerBreakEvent(event.getBlock(), event.getBlock());
            Bukkit.getPluginManager().callEvent((Event)hnpbe);
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void pistonPullEvent(BlockPistonRetractEvent event) {
        List blocks = event.getBlocks();
        for (Block b : blocks) {
            if (!this.blockManager.isHoneypotBlock(b)) continue;
            this.logger.debug((Component)Component.text((String)("PistonRetractEvent being called for Honeypot: " + b.getX() + ", " + b.getY() + ", " + b.getZ())));
            HoneypotNonPlayerBreakEvent hnpbe = new HoneypotNonPlayerBreakEvent(event.getBlock(), event.getBlock());
            Bukkit.getPluginManager().callEvent((Event)hnpbe);
            event.setCancelled(true);
            break;
        }
    }
}

