/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.events.BlockBreakEventListener;
import org.reprogle.honeypot.common.events.BlockBurnEventListener;
import org.reprogle.honeypot.common.events.BlockFormEventListener;
import org.reprogle.honeypot.common.events.BlockFromToEventListener;
import org.reprogle.honeypot.common.events.EntityChangeBlockEventListener;
import org.reprogle.honeypot.common.events.EntityExplodeEventListener;
import org.reprogle.honeypot.common.events.InventoryClickDragEventListener;
import org.reprogle.honeypot.common.events.InventoryMoveItemEventListener;
import org.reprogle.honeypot.common.events.LeavesDecayEventListener;
import org.reprogle.honeypot.common.events.PistonExtendRetractListener;
import org.reprogle.honeypot.common.events.PlayerInteractEventListener;
import org.reprogle.honeypot.common.events.PlayerJoinEventListener;
import org.reprogle.honeypot.common.events.SignChangeEventListener;
import org.reprogle.honeypot.common.events.StructureGrowEventListener;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class Listeners {
    private final Honeypot plugin;
    private final HoneypotConfigManager configManager;
    private final HoneypotLogger logger;
    @Inject
    BlockBreakEventListener blockBreakEventListener;
    @Inject
    BlockBurnEventListener blockBurnEventListener;
    @Inject
    EntityChangeBlockEventListener entityChangeBlockEventListener;
    @Inject
    EntityExplodeEventListener entityExplodeEventListener;
    @Inject
    PistonExtendRetractListener pistonExtendRetractListener;
    @Inject
    InventoryMoveItemEventListener inventoryMoveItemEventListener;
    @Inject
    StructureGrowEventListener structureGrowEventListener;
    @Inject
    PlayerJoinEventListener playerJoinEventListener;
    @Inject
    BlockFormEventListener blockFormEventListener;
    @Inject
    LeavesDecayEventListener leavesDecayEventListener;
    @Inject
    SignChangeEventListener signChangeEventListener;
    @Inject
    BlockFromToEventListener blockFromToEventListener;
    @Inject
    InventoryClickDragEventListener inventoryClickDragEventListener;
    @Inject
    PlayerInteractEventListener playerInteractEventListener;

    @Inject
    Listeners(Honeypot plugin, HoneypotConfigManager configManager, HoneypotLogger logger) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.logger = logger;
    }

    public void setupListeners() {
        ArrayList<PlayerJoinEventListener> primaryListeners = new ArrayList<PlayerJoinEventListener>(List.of(this.blockBreakEventListener, this.blockBurnEventListener, this.entityChangeBlockEventListener, this.entityExplodeEventListener, this.pistonExtendRetractListener, this.inventoryMoveItemEventListener, this.structureGrowEventListener, this.playerJoinEventListener));
        ArrayList<BlockFromToEventListener> secondaryListeners = new ArrayList<BlockFromToEventListener>(List.of(this.blockFormEventListener, this.leavesDecayEventListener, this.signChangeEventListener, this.blockFromToEventListener));
        PluginManager manager = this.plugin.getServer().getPluginManager();
        primaryListeners.forEach(event -> manager.registerEvents(event, (Plugin)this.plugin));
        if (this.configManager.getPluginConfig().getBoolean("container-actions.enable-container-actions").booleanValue()) {
            if (this.configManager.getPluginConfig().getBoolean("container-actions.use-inventory-click").booleanValue()) {
                this.logger.info((Component)Component.text((String)"Using inventory click for containers"));
                manager.registerEvents((Listener)this.inventoryClickDragEventListener, (Plugin)this.plugin);
            } else {
                this.logger.info((Component)Component.text((String)"Using player interact for containers"));
                manager.registerEvents((Listener)this.playerInteractEventListener, (Plugin)this.plugin);
            }
        }
        if (this.configManager.getPluginConfig().getBoolean("enable-extra-events").booleanValue()) {
            this.logger.info((Component)Component.text((String)"Extra events have been enabled. Some of the events can be noisy, and may cause additional lag on low-performance hardware, such as budget server hosts. If you experience lag, disable these events, Honeypot can still function without them!"));
            secondaryListeners.forEach(event -> manager.registerEvents(event, (Plugin)this.plugin));
        }
    }
}

