/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.LeavesDecayEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class LeavesDecayEventListener
implements Listener {
    private final HoneypotBlockManager honeypotBlockManager;
    private final HoneypotLogger logger;

    @Inject
    LeavesDecayEventListener(HoneypotBlockManager honeypotBlockManager, HoneypotLogger logger) {
        this.honeypotBlockManager = honeypotBlockManager;
        this.logger = logger;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLeavesDecayEvent(LeavesDecayEvent event) {
        Block block = event.getBlock();
        if (this.honeypotBlockManager.isHoneypotBlock(block)) {
            this.logger.debug((Component)Component.text((String)("LeavesDecayEvent being called for Honeypot: " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            event.setCancelled(true);
        }
    }
}

