/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;

public class InventoryMoveItemEventListener
implements Listener {
    private final HoneypotBlockManager blockManager;

    @Inject
    InventoryMoveItemEventListener(HoneypotBlockManager blockManager) {
        this.blockManager = blockManager;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        if (event.getInitiator().getType() != InventoryType.HOPPER && event.getInitiator().getType() != InventoryType.DROPPER) {
            return;
        }
        Location sourceLocation = event.getSource().getLocation();
        if (sourceLocation == null) {
            return;
        }
        Location destinationLocation = event.getDestination().getLocation();
        if (destinationLocation == null) {
            return;
        }
        World world = destinationLocation.getWorld();
        if (world == null) {
            return;
        }
        Block targetBlock = world.getBlockAt(destinationLocation);
        Block sourceBlock = world.getBlockAt(sourceLocation);
        boolean isSourceHoneypot = this.blockManager.isHoneypotBlock(sourceBlock);
        boolean isTargetHoneypot = this.blockManager.isHoneypotBlock(targetBlock);
        if (isSourceHoneypot || isTargetHoneypot) {
            event.setCancelled(true);
        }
    }
}

