/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.reprogle.honeypot.api.events.HoneypotInventoryClickEvent;
import org.reprogle.honeypot.api.events.HoneypotPreInventoryClickEvent;
import org.reprogle.honeypot.common.libs.spigui.spigui.menu.SGMenu;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.ActionHandler;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class InventoryClickDragEventListener
implements Listener {
    private final ActionHandler actionHandler;
    private final HoneypotBlockManager blockManager;
    private final HoneypotConfigManager configManager;
    private final HoneypotLogger logger;

    @Inject
    InventoryClickDragEventListener(ActionHandler actionHandler, HoneypotBlockManager blockManager, HoneypotConfigManager configManager, HoneypotLogger logger) {
        this.actionHandler = actionHandler;
        this.blockManager = blockManager;
        this.configManager = configManager;
        this.logger = logger;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void inventoryClickEvent(InventoryClickEvent event) {
        Block block;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getInventory().getHolder() instanceof DoubleChest) && !(event.getInventory().getHolder() instanceof Container) || event.getInventory().getHolder() instanceof SGMenu) {
            return;
        }
        if (!EnumSet.of(InventoryType.SlotType.CONTAINER, InventoryType.SlotType.CRAFTING, InventoryType.SlotType.FUEL, InventoryType.SlotType.RESULT).contains(event.getSlotType())) {
            return;
        }
        if (event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)holder;
            block = doubleChest.getWorld().getBlockAt(doubleChest.getLocation());
        } else {
            block = ((Container)event.getClickedInventory().getHolder()).getBlock();
        }
        if (!this.blockManager.isHoneypotBlock(block)) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (!this.checkFilter(block)) {
            return;
        }
        if (!block.getType().equals((Object)Material.ENDER_CHEST) && this.blockManager.isHoneypotBlock(Objects.requireNonNull(block))) {
            HoneypotPreInventoryClickEvent hpice = new HoneypotPreInventoryClickEvent(player, inventory);
            Bukkit.getPluginManager().callEvent((Event)hpice);
            if (hpice.isCancelled()) {
                return;
            }
            if (!(player.hasPermission("honeypot.exempt") || player.hasPermission("honeypot.*") || player.isOp())) {
                if (inventory.getItem(event.getSlot()) == null && this.configManager.getPluginConfig().getBoolean("container-actions.only-trigger-on-withdrawal").booleanValue()) {
                    return;
                }
                event.setCancelled(true);
                this.executeAction(player, block, inventory);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void inventoryDragEvent(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getInventory().getHolder() instanceof DoubleChest) && !(event.getInventory().getHolder() instanceof Container) || event.getInventory().getHolder() instanceof SGMenu) {
            return;
        }
        if (event.getInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        Block block = ((Container)event.getInventory().getHolder()).getBlock();
        Inventory inventory = event.getInventory();
        if (!this.checkFilter(block)) {
            return;
        }
        if (!block.getType().equals((Object)Material.ENDER_CHEST) && this.blockManager.isHoneypotBlock(Objects.requireNonNull(block))) {
            HoneypotPreInventoryClickEvent hpice = new HoneypotPreInventoryClickEvent(player, inventory);
            Bukkit.getPluginManager().callEvent((Event)hpice);
            if (hpice.isCancelled()) {
                return;
            }
            if (!(player.hasPermission("honeypot.exempt") || player.hasPermission("honeypot.*") || player.isOp())) {
                event.setCancelled(true);
                this.executeAction(player, block, inventory);
            }
        }
    }

    private void executeAction(Player player, Block block, Inventory inventory) {
        String action = this.blockManager.getAction(block);
        if (action == null) {
            this.logger.debug((Component)Component.text((String)("An InventoryClickEvent was called for player: " + player.getName() + ", UUID of " + String.valueOf(player.getUniqueId()) + ". However, the action was null, so this must be a FAKE HONEYPOT. Please investigate the block at " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            return;
        }
        this.logger.debug((Component)Component.text((String)("InventoryClickEvent being called for player: " + player.getName() + ", UUID of " + String.valueOf(player.getUniqueId()) + ". Action is: " + action)));
        this.actionHandler.handleCustomAction(action, block, player);
        HoneypotInventoryClickEvent hice = new HoneypotInventoryClickEvent(player, inventory);
        Bukkit.getPluginManager().callEvent((Event)hice);
    }

    private boolean checkFilter(Block block) {
        if (this.configManager.getPluginConfig().getBoolean("filters.inventories").booleanValue()) {
            List allowedBlocks = this.configManager.getPluginConfig().getList("allowed-inventories");
            for (String blockType : allowedBlocks) {
                if (!Objects.requireNonNull(block).getType().name().equals(blockType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

