/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.reprogle.honeypot.api.events.HoneypotNonPlayerBreakEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.storagemanager.HoneypotPlayerHistoryManager;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;

public class EntityExplodeEventListener
implements Listener {
    private final HoneypotLogger logger;
    private final HoneypotConfigManager configManager;
    private final HoneypotBlockManager blockManager;
    private final HoneypotPlayerHistoryManager playerHistoryManager;
    private final AdapterManager adapterManager;

    @Inject
    EntityExplodeEventListener(HoneypotLogger logger, HoneypotConfigManager configManager, HoneypotBlockManager blockManager, HoneypotPlayerHistoryManager playerHistoryManager, AdapterManager adapterManager) {
        this.logger = logger;
        this.configManager = configManager;
        this.blockManager = blockManager;
        this.playerHistoryManager = playerHistoryManager;
        this.adapterManager = adapterManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void entityExplodeEvent(EntityExplodeEvent event) {
        List destroyedBlocks = event.blockList();
        ArrayList<Block> foundHoneypotBlocks = new ArrayList<Block>();
        boolean allowExplosions = this.configManager.getPluginConfig().getBoolean("allow-explode");
        Entity e = event.getEntity();
        Entity source = null;
        if (e instanceof TNTPrimed) {
            TNTPrimed tnt = (TNTPrimed)e;
            source = tnt.getSource();
        }
        for (Block block : destroyedBlocks) {
            if (!Boolean.TRUE.equals(this.blockManager.isHoneypotBlock(block))) continue;
            this.logger.debug((Component)Component.text((String)("EntityExplodeEvent being called for Honeypot: " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            if (source instanceof Player) {
                if (!this.adapterManager.checkAllAdapters(((Player)source).getPlayer(), block.getLocation())) continue;
                this.playerHistoryManager.addPlayerHistory((Player)source, this.blockManager.getHoneypotBlock(block), "break");
                this.logger.debug((Component)Component.text((String)("EntityExplodeEvent was caused by a player! It has been logged in the history, and the Honeypot's action has been triggered for that player. Player was: " + source.getName())));
                BlockBreakEvent blockBreakEvent = new BlockBreakEvent(block, (Player)source);
                Bukkit.getPluginManager().callEvent((Event)blockBreakEvent);
            }
            HoneypotNonPlayerBreakEvent hnpbe = new HoneypotNonPlayerBreakEvent(event.getEntity(), block);
            Bukkit.getPluginManager().callEvent((Event)hnpbe);
            if (allowExplosions) {
                this.blockManager.deleteBlock(block);
                continue;
            }
            foundHoneypotBlocks.add(block);
        }
        destroyedBlocks.removeAll(foundHoneypotBlocks);
    }
}

