/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.reprogle.honeypot.api.events.HoneypotNonPlayerBreakEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class EntityChangeBlockEventListener
implements Listener {
    private final HoneypotLogger logger;
    private final HoneypotBlockManager blockManager;
    private final HoneypotConfigManager configManager;

    @Inject
    EntityChangeBlockEventListener(HoneypotLogger logger, HoneypotBlockManager blockManager, HoneypotConfigManager configManager) {
        this.logger = logger;
        this.blockManager = blockManager;
        this.configManager = configManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void entityChangeBlockEvent(EntityChangeBlockEvent event) {
        if (event.getEntity().getType().equals((Object)EntityType.ENDERMAN)) {
            if (Boolean.TRUE.equals(this.blockManager.isHoneypotBlock(event.getBlock()))) {
                this.logger.debug((Component)Component.text((String)("EntityChangeBlockEvent being called for Honeypot: " + event.getBlock().getX() + ", " + event.getBlock().getY() + ", " + event.getBlock().getZ())));
                HoneypotNonPlayerBreakEvent hnpbe = new HoneypotNonPlayerBreakEvent(event.getEntity(), event.getBlock());
                Bukkit.getPluginManager().callEvent((Event)hnpbe);
                if (Boolean.TRUE.equals(this.configManager.getPluginConfig().getBoolean("allow-enderman"))) {
                    this.blockManager.deleteBlock(event.getBlock());
                } else {
                    event.setCancelled(true);
                }
            }
        } else if (event.getEntity().getType().equals((Object)EntityType.SILVERFISH) && Boolean.TRUE.equals(this.blockManager.isHoneypotBlock(event.getBlock()))) {
            HoneypotNonPlayerBreakEvent hnpbe = new HoneypotNonPlayerBreakEvent(event.getEntity(), event.getBlock());
            Bukkit.getPluginManager().callEvent((Event)hnpbe);
            event.setCancelled(true);
        }
    }
}

