/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class BlockFromToEventListener
implements Listener {
    private final HoneypotLogger logger;
    private final HoneypotBlockManager blockManager;

    @Inject
    BlockFromToEventListener(HoneypotLogger logger, HoneypotBlockManager blockManager) {
        this.logger = logger;
        this.blockManager = blockManager;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void blockFromToEvent(BlockFromToEvent event) {
        if (event.getFace() == BlockFace.DOWN) {
            return;
        }
        Block toBlock = event.getToBlock();
        if (this.blockManager.isHoneypotBlock(toBlock) && event.getFace() != BlockFace.DOWN) {
            this.logger.debug((Component)Component.text((String)("BlockFromToEvent being called for Honeypot: " + toBlock.getX() + ", " + toBlock.getY() + ", " + toBlock.getZ())));
            event.setCancelled(true);
        }
    }
}

