/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class BlockFormEventListener
implements Listener {
    private final HoneypotLogger logger;
    private final HoneypotBlockManager blockManager;

    @Inject
    BlockFormEventListener(HoneypotLogger logger, HoneypotBlockManager blockManager) {
        this.logger = logger;
        this.blockManager = blockManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFormEvent(BlockFormEvent event) {
        Block block = event.getBlock();
        if (this.blockManager.isHoneypotBlock(block)) {
            this.logger.debug((Component)Component.text((String)("BlockFormEvent being called for Honeypot: " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            event.setCancelled(true);
        }
    }
}

