/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class BlockBurnEventListener
implements Listener {
    private final HoneypotLogger logger;
    private final HoneypotBlockManager blockManager;

    @Inject
    BlockBurnEventListener(HoneypotLogger logger, HoneypotBlockManager blockManager) {
        this.logger = logger;
        this.blockManager = blockManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurnEvent(BlockBurnEvent event) {
        Block block = event.getBlock();
        if (this.blockManager.isHoneypotBlock(block)) {
            Block[] adjacentBlocks;
            this.logger.debug((Component)Component.text((String)("BlockBurnEvent being called for Honeypot: " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
            event.setCancelled(true);
            for (Block adjacentBlock : adjacentBlocks = new Block[]{block.getRelative(BlockFace.UP), block.getRelative(BlockFace.DOWN), block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST)}) {
                if (adjacentBlock.getType() != Material.FIRE || adjacentBlock.getRelative(BlockFace.DOWN).getType() == Material.NETHERRACK) continue;
                adjacentBlock.setType(Material.AIR);
            }
            Block aboveBlock = block.getRelative(BlockFace.UP);
            if (aboveBlock.getType() == Material.FIRE) {
                aboveBlock.setType(Material.AIR);
            }
        }
    }
}

