/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.events;

import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.reprogle.honeypot.api.events.HoneypotPlayerBreakEvent;
import org.reprogle.honeypot.api.events.HoneypotPrePlayerBreakEvent;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.storagemanager.HoneypotPlayerHistoryManager;
import org.reprogle.honeypot.common.storagemanager.HoneypotPlayerManager;
import org.reprogle.honeypot.common.utils.ActionHandler;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.discord.DiscordWebhookNotifier;
import org.reprogle.honeypot.common.utils.discord.WebhookActionType;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;

public class BlockBreakEventListener
implements Listener {
    private static final String BREAK_PERMISSION = "honeypot.break";
    private static final String WILDCARD_PERMISSION = "honeypot.*";
    private static final String EXEMPT_PERMISSION = "honeypot.exempt";
    private final ActionHandler actionHandler;
    private final HoneypotLogger logger;
    private final HoneypotBlockManager blockManager;
    private final HoneypotConfigManager configManager;
    private final CommandFeedback commandFeedback;
    private final HoneypotPlayerHistoryManager playerHistoryManager;
    private final HoneypotPlayerManager playerManager;
    private final AdapterManager adapterManager;

    @Inject
    public BlockBreakEventListener(ActionHandler actionHandler, HoneypotLogger logger, HoneypotBlockManager blockManager, HoneypotConfigManager configManager, CommandFeedback commandFeedback, HoneypotPlayerHistoryManager playerHistoryManager, HoneypotPlayerManager playerManager, AdapterManager adapterManager) {
        this.actionHandler = actionHandler;
        this.logger = logger;
        this.blockManager = blockManager;
        this.configManager = configManager;
        this.commandFeedback = commandFeedback;
        this.playerHistoryManager = playerHistoryManager;
        this.playerManager = playerManager;
        this.adapterManager = adapterManager;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockBreakEvent(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockManager.isHoneypotBlock(event.getBlock())) {
            if (!this.adapterManager.checkAllAdapters(player, event.getBlock().getLocation())) {
                this.blockManager.deleteBlock(event.getBlock());
                return;
            }
            HoneypotPrePlayerBreakEvent hppbe = new HoneypotPrePlayerBreakEvent(player, event.getBlock());
            Bukkit.getPluginManager().callEvent((Event)hppbe);
            this.logger.debug((Component)Component.text((String)("Pre block break event is being called for " + String.valueOf(player))));
            if (hppbe.isCancelled()) {
                this.blockManager.deleteBlock(event.getBlock());
                this.logger.debug((Component)Component.text((String)("The event for " + String.valueOf(player) + " was cancelled, not continuing.")));
                return;
            }
            boolean deleteBlock = false;
            if (this.configManager.getPluginConfig().getBoolean("allow-player-destruction").booleanValue() || player.hasPermission(BREAK_PERMISSION) || player.hasPermission(WILDCARD_PERMISSION) || player.isOp()) {
                deleteBlock = true;
                this.logger.debug((Component)Component.text((String)"The player who broke this block is either allowed to break it, or has some sort of permission. This Honeypot will be removed from the world"));
            } else {
                event.setCancelled(true);
            }
            if (this.configManager.getPluginConfig().getInt("blocks-broken-before-action-taken") <= 1) {
                this.playerManager.setPlayerCount(player, 0);
                this.logger.debug((Component)Component.text((String)"Action is being taken for this event."));
                this.breakAction(event);
            } else {
                this.logger.debug((Component)Component.text((String)"The break is just being counted, no action is taken yet"));
                this.countBreak(event);
            }
            HoneypotPlayerBreakEvent hpbe = new HoneypotPlayerBreakEvent(player, event.getBlock());
            Bukkit.getPluginManager().callEvent((Event)hpbe);
            if (deleteBlock) {
                this.blockManager.deleteBlock(event.getBlock());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void checkBlockBreakSideEffects(BlockBreakEvent event) {
        Block[] adjacentBlocks;
        if (!this.configManager.getPluginConfig().getBoolean("allow-player-destruction").booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player.hasPermission(BREAK_PERMISSION) || player.hasPermission(WILDCARD_PERMISSION) || player.isOp())) {
            return;
        }
        Block block = event.getBlock();
        for (Block adjacentBlock : adjacentBlocks = new Block[]{block.getRelative(BlockFace.DOWN), block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST), block.getRelative(BlockFace.UP)}) {
            if (!adjacentBlock.getType().equals((Object)Material.AIR) || !this.blockManager.isHoneypotBlock(adjacentBlock)) continue;
            this.blockBreakEvent(new BlockBreakEvent(adjacentBlock, player));
            this.blockManager.deleteBlock(adjacentBlock);
            this.logger.warning((Component)Component.text((String)("A Honeypot has been removed due to the block it's attached to being broken. It was located at " + adjacentBlock.getX() + ", " + adjacentBlock.getY() + ", " + adjacentBlock.getZ() + ". " + player.getName() + " is the player that indirectly broke it, so the assigned action was ran against them. If needed, please recreate the Honeypot")));
        }
    }

    private void breakAction(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!(player.hasPermission(EXEMPT_PERMISSION) || player.hasPermission(BREAK_PERMISSION) || player.hasPermission(WILDCARD_PERMISSION) || player.isOp())) {
            String action = this.blockManager.getAction(block);
            if (action == null) {
                this.logger.debug((Component)Component.text((String)("A BlockBreakEvent was called for player: " + player.getName() + ", UUID of " + String.valueOf(player.getUniqueId()) + ". However, the action was null, so this must be a FAKE HONEYPOT. Please investigate the block at " + block.getX() + ", " + block.getY() + ", " + block.getZ())));
                return;
            }
            this.playerHistoryManager.addPlayerHistory(player, this.blockManager.getHoneypotBlock(event.getBlock()), "break");
            this.actionHandler.handleCustomAction(action, block, player);
            this.sendWebhook(event);
        } else if (player.hasPermission(BREAK_PERMISSION) || player.hasPermission(WILDCARD_PERMISSION) || player.isOp()) {
            player.sendMessage(this.commandFeedback.sendCommandFeedback("staff-broke", new Boolean[0]));
        }
    }

    private void countBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission(EXEMPT_PERMISSION) || player.isOp() || player.hasPermission(BREAK_PERMISSION) || player.hasPermission(WILDCARD_PERMISSION)) {
            return;
        }
        int breaksBeforeAction = this.configManager.getPluginConfig().getInt("blocks-broken-before-action-taken");
        int blocksBroken = this.playerManager.getCount(player);
        if (blocksBroken == -1) {
            this.playerManager.addPlayer(player, 0);
            blocksBroken = 0;
        }
        if (++blocksBroken >= breaksBeforeAction || breaksBeforeAction == 1) {
            this.playerManager.setPlayerCount(player, 0);
            this.breakAction(event);
        } else {
            this.playerManager.setPlayerCount(player, blocksBroken);
            this.playerHistoryManager.addPlayerHistory(player, this.blockManager.getHoneypotBlock(event.getBlock()), "prelimBreak");
            this.logger.debug((Component)Component.text((String)("BlockBreakEvent being called for player: " + player.getName() + ", UUID of " + String.valueOf(player.getUniqueId()) + ".")));
            this.sendWebhook(event);
        }
    }

    private void sendWebhook(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.configManager.getPluginConfig().getBoolean("discord.enable").booleanValue()) {
            String sendWhen = this.configManager.getPluginConfig().getString("discord.send-when");
            WebhookActionType actionType = sendWhen.equalsIgnoreCase("onbreak") ? WebhookActionType.BREAK : WebhookActionType.ACTION;
            new DiscordWebhookNotifier(actionType, this.configManager.getPluginConfig().getString("discord.url"), event.getBlock(), player, this.logger).send();
        }
    }
}

