/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotPermission;

public class HoneypotRemove
implements HoneypotSubCommand {
    private final HoneypotConfigManager configManager;
    private final HoneypotBlockManager blockManager;
    private final CommandFeedback commandFeedback;

    @Inject
    public HoneypotRemove(HoneypotConfigManager configManager, HoneypotBlockManager blockManager, CommandFeedback commandFeedback) {
        this.configManager = configManager;
        this.blockManager = blockManager;
        this.commandFeedback = commandFeedback;
    }

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public void perform(Player p, String[] args) {
        Block block = p.getTargetBlockExact(5);
        if (args.length >= 2) {
            switch (args[1].toLowerCase()) {
                case "all": {
                    this.blockManager.deleteAllHoneypotBlocks(p.getWorld());
                    p.sendMessage(this.commandFeedback.sendCommandFeedback("deleted", true));
                    break;
                }
                case "near": {
                    int radius = this.configManager.getPluginConfig().getInt("search-range");
                    List<HoneypotBlockObject> honeypots = Registry.getStorageProvider().getNearbyHoneypots(p.getLocation(), radius);
                    if (honeypots.isEmpty()) {
                        p.sendMessage(this.commandFeedback.sendCommandFeedback("no-pots-found", new Boolean[0]));
                        return;
                    }
                    for (HoneypotBlockObject honeypot : honeypots) {
                        this.blockManager.deleteBlock(honeypot.getBlock());
                    }
                    p.sendMessage(this.commandFeedback.sendCommandFeedback("deleted", false));
                    break;
                }
                default: {
                    this.potRemovalCheck(block, p);
                    break;
                }
            }
        } else {
            this.potRemovalCheck(block, p);
        }
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        ArrayList<String> subcommands = new ArrayList<String>();
        if (args.length == 2) {
            subcommands.add("all");
            subcommands.add("near");
        }
        return subcommands;
    }

    private void potRemovalCheck(Block block, Player p) {
        assert (block != null);
        if (this.blockManager.isHoneypotBlock(block)) {
            this.blockManager.deleteBlock(block);
            p.sendMessage(this.commandFeedback.sendCommandFeedback("success", false));
        } else {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("not-a-honeypot", new Boolean[0]));
        }
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.remove"));
        permissions.add(new HoneypotPermission("honeypot.break"));
        return permissions;
    }
}

