/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.storagemanager.CacheManager;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.utils.GhostHoneypotFixer;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.HoneypotPermission;

public class HoneypotReload
implements HoneypotSubCommand {
    private final HoneypotConfigManager configManager;
    private final GhostHoneypotFixer fixer;
    private final CommandFeedback commandFeedback;
    private final Honeypot plugin;
    private final HoneypotLogger logger;

    @Inject
    public HoneypotReload(Honeypot plugin, HoneypotConfigManager configManager, GhostHoneypotFixer fixer, CommandFeedback commandFeedback, HoneypotLogger logger) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.fixer = fixer;
        this.commandFeedback = commandFeedback;
        this.logger = logger;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public void perform(Player p, String[] args) {
        try {
            this.configManager.getPluginConfig().reload();
            this.configManager.getPluginConfig().save();
            this.configManager.getGuiConfig().reload();
            this.configManager.getGuiConfig().save();
            this.configManager.getHoneypotsConfig().reload();
            this.configManager.getHoneypotsConfig().save();
            this.configManager.getLanguageFile().reload();
            this.configManager.getLanguageFile().save();
            this.fixer.cancelTask();
            if (this.configManager.getPluginConfig().getBoolean("ghost-honeypot-checker.enable").booleanValue()) {
                this.fixer.startTask();
            }
            CacheManager.clearCache();
            String providerName = this.configManager.getPluginConfig().getString("storage-method");
            if (!Registry.getStorageProvider().getProviderName().equalsIgnoreCase(providerName)) {
                StorageProvider provider = Registry.getStorageManagerRegistry().getStorageProvider(providerName);
                if (provider != null) {
                    if (!this.configManager.getPluginConfig().getBoolean("allow-third-party-storage-providers").booleanValue()) {
                        this.logger.severe((Component)Component.text((String)"The storage method was updated to a custom provider, but the server is not configured to allow third-party storage providers! On your next reboot Honeypot WILL crash ON PURPOSE! Please validate your config"));
                    }
                    Registry.setStorageProvider(provider);
                    this.logger.info((Component)Component.text((String)("The storage provider was updated to \"" + providerName + "\"")));
                } else {
                    this.logger.severe((Component)Component.text((String)("The storage provider was updated to \"" + providerName + "\" but it is not registered! On your next reboot Honeypot WILL crash ON PURPOSE! Please validate your config")));
                }
            }
            p.sendMessage(this.commandFeedback.sendCommandFeedback("reload", new Boolean[0]));
            this.logger.info((Component)Component.text((String)"Honeypot has successfully been reloaded"));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load config file, disabling! Please alert the plugin author with the following info:" + String.valueOf(e));
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        return new ArrayList<String>();
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.reload"));
        return permissions;
    }
}

