/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.storagemanager.pdc.DataStoreManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.HoneypotPermission;

public class HoneypotMigrate
implements HoneypotSubCommand {
    private final CommandFeedback commandFeedback;
    private final HoneypotConfigManager configManager;
    private final HoneypotBlockManager hbm;
    private final Honeypot plugin;
    private final DataStoreManager dataStoreManager;
    private final HoneypotLogger logger;

    @Inject
    public HoneypotMigrate(CommandFeedback commandFeedback, HoneypotConfigManager configManager, HoneypotBlockManager hbm, Honeypot plugin, DataStoreManager dataStoreManager, HoneypotLogger logger) {
        this.commandFeedback = commandFeedback;
        this.configManager = configManager;
        this.hbm = hbm;
        this.plugin = plugin;
        this.dataStoreManager = dataStoreManager;
        this.logger = logger;
    }

    @Override
    public String getName() {
        return "migrate";
    }

    @Override
    public void perform(Player p, String[] args) throws IOException {
        if (this.configManager.getPluginConfig().getString("storage-method").equalsIgnoreCase("pdc")) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("migrate", false));
            return;
        }
        if (args.length == 1) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("migrate", new Boolean[0]));
        } else if (args.length >= 2 && args[1].equalsIgnoreCase("confirm")) {
            this.logger.severe(this.commandFeedback.getChatPrefix().append((Component)Component.text((String)(p.getName() + " has started migrating Honeypot to PDC!!! "))).append((Component)Component.text((String)"They were warned that this will cause Honeypot to shutdown afterwards. If you heavily rely on Honeypot, PLEASE restart ASAP!")));
            List worlds = this.plugin.getServer().getWorlds();
            for (World world : worlds) {
                List<HoneypotBlockObject> blocks = this.hbm.getAllHoneypots(world);
                for (HoneypotBlockObject block : blocks) {
                    this.dataStoreManager.createHoneypotBlock(block.getBlock(), block.getAction());
                }
            }
            p.sendMessage(this.commandFeedback.sendCommandFeedback("migrate", true));
            this.configManager.getPluginConfig().set("storage-method", (Object)"pdc");
            this.configManager.getPluginConfig().save();
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        return List.of("confirm");
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.migrate"));
        return permissions;
    }
}

