/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotPermission;

public class HoneypotLocate
implements HoneypotSubCommand {
    private final Honeypot plugin;
    private final HoneypotConfigManager configManager;
    private final CommandFeedback commandFeedback;

    @Inject
    public HoneypotLocate(Honeypot plugin, HoneypotConfigManager configManager, CommandFeedback commandFeedback) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.commandFeedback = commandFeedback;
    }

    @Override
    public String getName() {
        return "locate";
    }

    @Override
    public void perform(Player p, String[] args) {
        int radius;
        if (args.length == 2) {
            try {
                radius = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("invalid-radius", new Boolean[0]));
                radius = this.configManager.getPluginConfig().getInt("search-range");
            }
        } else {
            radius = this.configManager.getPluginConfig().getInt("search-range");
        }
        boolean potFound = false;
        List<HoneypotBlockObject> honeypots = Registry.getStorageProvider().getNearbyHoneypots(p.getLocation(), radius);
        if (!honeypots.isEmpty()) {
            potFound = true;
        }
        for (HoneypotBlockObject honeypot : honeypots) {
            Slime slime = (Slime)Objects.requireNonNull(Bukkit.getWorld((String)honeypot.getBlock().getWorld().getName())).spawnEntity(honeypot.getBlock().getLocation().add(0.5, 0.0, 0.5), EntityType.SLIME);
            slime.setSize(2);
            slime.setAI(false);
            slime.setGlowing(true);
            slime.setInvulnerable(true);
            slime.setHealth(slime.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
            slime.setInvisible(true);
            slime.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> slime.remove(), null, 100L);
        }
        if (potFound) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("found-pots", new Boolean[0]));
        } else {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("no-pots-found", new Boolean[0]));
        }
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        return new ArrayList<String>();
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.locate"));
        return permissions;
    }
}

