/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.storagemanager.HoneypotPlayerHistoryManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotPlayerHistoryObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotPermission;

public class HoneypotHistory
implements HoneypotSubCommand {
    private final CommandFeedback commandFeedback;
    private final HoneypotConfigManager configManager;
    private final HoneypotPlayerHistoryManager playerHistoryManager;

    @Inject
    public HoneypotHistory(CommandFeedback commandFeedback, HoneypotConfigManager configManager, HoneypotPlayerHistoryManager playerHistoryManager) {
        this.commandFeedback = commandFeedback;
        this.configManager = configManager;
        this.playerHistoryManager = playerHistoryManager;
    }

    @Override
    public String getName() {
        return "history";
    }

    @Override
    public void perform(Player p, String[] args) {
        if (args.length >= 3 && (args[1].equalsIgnoreCase("delete") || args[1].equalsIgnoreCase("query"))) {
            Player argPlayer = Bukkit.getPlayer((String)args[2]);
            if (argPlayer == null || !Bukkit.getPlayer((String)args[2]).isOnline()) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("not-online", new Boolean[0]));
                return;
            }
            if (args[1].equalsIgnoreCase("query")) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("searching", new Boolean[0]));
                List<HoneypotPlayerHistoryObject> history = this.playerHistoryManager.getPlayerHistory(argPlayer);
                int length = this.configManager.getPluginConfig().getInt("history-length");
                if (history.size() > length) {
                    p.sendMessage(this.commandFeedback.sendCommandFeedback("truncating", new Boolean[0]));
                    history = history.subList(0, length);
                }
                if (history.isEmpty()) {
                    p.sendMessage(this.commandFeedback.sendCommandFeedback("no-history", new Boolean[0]));
                    return;
                }
                Collections.reverse(history);
                int limit = Math.min(history.size(), length);
                for (int i = 0; i < limit; ++i) {
                    p.sendMessage(((TextComponent)Component.text((String)"\n-------[ ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)history.get(i).getDateTime(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" ]-------", (TextColor)NamedTextColor.GOLD)));
                    Location location = history.get(i).getHoneypot().getLocation();
                    Component playerInfo = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Player: ").color((TextColor)NamedTextColor.GOLD)).append((Component)Component.text((String)history.get(i).getPlayer(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" @ ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)(history.get(i).getHoneypot().getWorld() + " "), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)history.get(i).getHoneypot().getCoordinates(), (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.callback(audience -> {
                        Player player = (Player)audience;
                        player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    }))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent)Component.text((String)"Click to teleport").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC)));
                    p.sendMessage(playerInfo);
                    p.sendMessage(Component.text((String)"Action: ").append((Component)Component.text((String)history.get(i).getHoneypot().getAction(), (TextColor)NamedTextColor.GOLD)));
                    p.sendMessage(Component.text((String)"Break type: ").append((Component)Component.text((String)history.get(i).getType(), (TextColor)NamedTextColor.GOLD)));
                    p.sendMessage((Component)Component.text((String)"----------------------------------", (TextColor)NamedTextColor.GOLD));
                }
            } else if (args[1].equalsIgnoreCase("delete")) {
                if (args.length >= 4) {
                    this.playerHistoryManager.deletePlayerHistory(argPlayer, Integer.parseInt(args[3]));
                } else {
                    this.playerHistoryManager.deletePlayerHistory(argPlayer, new int[0]);
                }
                p.sendMessage(this.commandFeedback.sendCommandFeedback("success", new Boolean[0]));
            }
        } else if (args.length == 2 && args[1].equalsIgnoreCase("purge")) {
            this.playerHistoryManager.deleteAllHistory();
            p.sendMessage(this.commandFeedback.sendCommandFeedback("success", new Boolean[0]));
        } else {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("usage", new Boolean[0]));
        }
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        ArrayList<String> subcommands;
        block3: {
            block4: {
                block2: {
                    subcommands = new ArrayList<String>();
                    if (args.length != 2) break block2;
                    subcommands.add("delete");
                    subcommands.add("query");
                    subcommands.add("purge");
                    break block3;
                }
                if (args.length != 3 || !args[1].equalsIgnoreCase("query") && !args[1].equalsIgnoreCase("delete")) break block4;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    subcommands.add(player.getName());
                }
                break block3;
            }
            if (args.length != 4 || !args[1].equalsIgnoreCase("delete")) break block3;
            for (int i = 1; i < 10; ++i) {
                subcommands.add(Integer.toString(i));
            }
        }
        return subcommands;
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.history"));
        return permissions;
    }
}

