/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.api.events.HoneypotPreCreateEvent;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.libs.spigui.spigui.buttons.SGButton;
import org.reprogle.honeypot.common.libs.spigui.spigui.item.ItemBuilder;
import org.reprogle.honeypot.common.libs.spigui.spigui.menu.SGMenu;
import org.reprogle.honeypot.common.providers.BehaviorProvider;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotPermission;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;
import org.reprogle.honeypot.common.utils.integrations.GriefPreventionAdapter;
import org.reprogle.honeypot.common.utils.integrations.LandsAdapter;
import org.reprogle.honeypot.common.utils.integrations.WorldGuardAdapter;

public class HoneypotGUI
implements HoneypotSubCommand {
    private final Honeypot plugin;
    private final HoneypotConfigManager configManager;
    private final HoneypotBlockManager blockManager;
    private final CommandFeedback commandFeedback;
    private final AdapterManager adapterManager;

    @Inject
    HoneypotGUI(Honeypot plugin, HoneypotConfigManager configManager, HoneypotBlockManager blockManager, CommandFeedback commandFeedback, AdapterManager adapterManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.blockManager = blockManager;
        this.commandFeedback = commandFeedback;
        this.adapterManager = adapterManager;
    }

    @Override
    public String getName() {
        return "gui";
    }

    @Override
    public void perform(Player p, String[] args) {
        p.openInventory(this.mainMenu(p).getInventory());
    }

    private void customHoneypotsInventory(Player p) {
        SGMenu customHoneypotsGUI = this.plugin.getGUI().create("Custom Honeypot", 3);
        ArrayList<String> types = new ArrayList<String>();
        Set keys = this.configManager.getHoneypotsConfig().getKeys();
        for (Object key : keys) {
            types.add(key.toString());
        }
        ConcurrentMap<String, BehaviorProvider> map = Registry.getBehaviorRegistry().getBehaviorProviders();
        map.forEach((providerName, provider) -> types.add((String)providerName));
        for (String type : types) {
            String action;
            ItemBuilder item = Registry.getBehaviorRegistry().getBehaviorProvider(type) == null ? ((action = this.configManager.getHoneypotsConfig().getString(type + ".icon")) != null && !action.isEmpty() ? new ItemBuilder(this.safeGetMaterial(action)) : new ItemBuilder(Material.PAPER)) : new ItemBuilder(Registry.getBehaviorRegistry().getBehaviorProvider(type).getIcon());
            item.name(type);
            item.lore("Click to create a Honeypot of this type");
            SGButton button = new SGButton(item.build()).withListener(event -> this.createHoneypotFromGUI(event, type));
            customHoneypotsGUI.addButton(button);
        }
        p.openInventory(customHoneypotsGUI.getInventory());
    }

    private void allHoneypotsInventory(Player p) {
        if (!p.hasPermission("honeypot.locate")) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("nopermission", new Boolean[0]));
            return;
        }
        SGMenu allBlocksGUI = this.plugin.getGUI().create("Honeypots {currentPage}/{maxPage}", 3);
        for (HoneypotBlockObject honeypotBlock : this.blockManager.getAllHoneypots(p.getWorld())) {
            ItemBuilder item = this.configManager.getGuiConfig().getBoolean("display-button-as-honeypot") != false ? new ItemBuilder(honeypotBlock.getBlock().getType()) : new ItemBuilder(this.safeGetMaterial(this.configManager.getGuiConfig().getString("default-gui-button")));
            item.lore("Click to teleport to Honeypot");
            item.name("Honeypot: " + honeypotBlock.getCoordinates());
            SGButton button = new SGButton(item.build()).withListener(event -> {
                event.getWhoClicked().sendMessage(Component.text((String)"Whoosh!", (TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC));
                event.getWhoClicked().teleportAsync(honeypotBlock.getLocation().add(0.5, 1.0, 0.5));
                event.getWhoClicked().closeInventory();
            });
            allBlocksGUI.addButton(button);
        }
        p.openInventory(allBlocksGUI.getInventory());
    }

    private void historyQueryInventory(Player p) {
        if (!p.hasPermission("honeypot.history")) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("nopermission", new Boolean[0]));
            return;
        }
        SGMenu historyQueryGUI = this.plugin.getGUI().create("Query Player History", 3);
        for (Player player : Bukkit.getOnlinePlayers()) {
            ItemStack skullItem = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta skullMeta = (SkullMeta)skullItem.getItemMeta();
            assert (skullMeta != null);
            skullMeta.setOwningPlayer((OfflinePlayer)player);
            skullItem.setItemMeta((ItemMeta)skullMeta);
            ItemBuilder item = new ItemBuilder(skullItem);
            item.name(player.getName());
            SGButton button = new SGButton(item.build()).withListener(event -> {
                event.getWhoClicked().closeInventory();
                Bukkit.dispatchCommand((CommandSender)event.getWhoClicked(), (String)("honeypot history query " + item.getName()));
            });
            historyQueryGUI.addButton(button);
        }
        p.openInventory(historyQueryGUI.getInventory());
    }

    private void removeHoneypotInventory(Player p) {
        if (!p.hasPermission("honeypot.remove")) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("nopermission", new Boolean[0]));
            return;
        }
        SGMenu removeGUI = this.plugin.getGUI().create("Remove Honeypots", 1);
        ItemBuilder removeAllItem = new ItemBuilder(Material.getMaterial((String)this.configManager.getGuiConfig().getString("remove-buttons.remove-all-button")));
        removeAllItem.name("Remove all Honeypots");
        ItemBuilder removeNearItem = new ItemBuilder(Material.getMaterial((String)this.configManager.getGuiConfig().getString("remove-buttons.remove-near-button")));
        removeNearItem.name("Remove nearby Honeypots");
        ItemBuilder removeTargetItem = new ItemBuilder(Material.getMaterial((String)this.configManager.getGuiConfig().getString("remove-buttons.remove-target-button")));
        removeTargetItem.name("Remove the Honeypot you're targeting");
        SGButton removeAllButton = new SGButton(removeAllItem.build()).withListener(event -> {
            event.getWhoClicked().closeInventory();
            this.blockManager.deleteAllHoneypotBlocks(p.getWorld());
            p.sendMessage(this.commandFeedback.sendCommandFeedback("deleted", true));
        });
        SGButton removeNearButton = new SGButton(removeNearItem.build()).withListener(event -> {
            event.getWhoClicked().closeInventory();
            int radius = this.configManager.getPluginConfig().getInt("search-range");
            List<HoneypotBlockObject> honeypots = Registry.getStorageProvider().getNearbyHoneypots(p.getLocation(), radius);
            if (honeypots.isEmpty()) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("no-pots-found", new Boolean[0]));
                return;
            }
            for (HoneypotBlockObject honeypot : honeypots) {
                this.blockManager.deleteBlock(honeypot.getBlock());
            }
            p.sendMessage(this.commandFeedback.sendCommandFeedback("deleted", false));
        });
        SGButton removeTargetButton = new SGButton(removeTargetItem.build()).withListener(event -> {
            event.getWhoClicked().closeInventory();
            if (event.getWhoClicked().getTargetBlockExact(5) == null) {
                event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("not-looking-at-block", new Boolean[0]));
                return;
            }
            Block block = event.getWhoClicked().getTargetBlockExact(5);
            if (block == null) {
                event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("not-looking-at-block", new Boolean[0]));
                return;
            }
            if (this.blockManager.isHoneypotBlock(block)) {
                this.blockManager.deleteBlock(block);
                p.sendMessage(this.commandFeedback.sendCommandFeedback("success", false));
            } else {
                event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("not-a-honeypot", new Boolean[0]));
            }
        });
        removeGUI.setButton(3, removeTargetButton);
        removeGUI.setButton(4, removeNearButton);
        removeGUI.setButton(5, removeAllButton);
        p.openInventory(removeGUI.getInventory());
    }

    private void createHoneypotFromGUI(InventoryClickEvent event, String action) {
        WorldGuardAdapter wga = this.adapterManager.getWorldGuardAdapter();
        GriefPreventionAdapter gpa = this.adapterManager.getGriefPreventionAdapter();
        LandsAdapter la = this.adapterManager.getLandsAdapter();
        if (event.getWhoClicked().getTargetBlockExact(5) == null) {
            event.getWhoClicked().closeInventory();
            event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("not-looking-at-block", new Boolean[0]));
            return;
        }
        Block block = event.getWhoClicked().getTargetBlockExact(5);
        if (wga != null && !wga.isAllowed((Player)event.getWhoClicked(), block.getLocation())) {
            event.getWhoClicked().closeInventory();
            event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("worldguard", new Boolean[0]));
            return;
        }
        if (gpa != null && !gpa.isAllowed((Player)event.getWhoClicked(), block.getLocation())) {
            event.getWhoClicked().closeInventory();
            event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("griefprevention", new Boolean[0]));
            return;
        }
        if (la != null && !la.isAllowed(block.getLocation())) {
            event.getWhoClicked().closeInventory();
            event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("lands", new Boolean[0]));
            return;
        }
        if (this.configManager.getPluginConfig().getBoolean("filters.blocks").booleanValue() || this.configManager.getPluginConfig().getBoolean("filters.inventories").booleanValue()) {
            List allowedBlocks = this.configManager.getPluginConfig().getList("allowed-blocks");
            List allowedInventories = this.configManager.getPluginConfig().getList("allowed-inventories");
            boolean allowed = false;
            if (this.configManager.getPluginConfig().getBoolean("filters.blocks").booleanValue()) {
                for (String blockType : allowedBlocks) {
                    if (!block.getType().name().equals(blockType)) continue;
                    allowed = true;
                    break;
                }
            }
            if (this.configManager.getPluginConfig().getBoolean("filters.inventories").booleanValue()) {
                for (String blockType : allowedInventories) {
                    if (!block.getType().name().equals(blockType)) continue;
                    allowed = true;
                    break;
                }
            }
            if (!allowed) {
                event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("against-filter", new Boolean[0]));
                return;
            }
        }
        event.getWhoClicked().closeInventory();
        if (this.blockManager.isHoneypotBlock(block)) {
            event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("already-exists", new Boolean[0]));
        } else {
            HoneypotPreCreateEvent hpce = new HoneypotPreCreateEvent((Player)event.getWhoClicked(), block);
            Bukkit.getPluginManager().callEvent((Event)hpce);
            if (hpce.isCancelled()) {
                return;
            }
            this.blockManager.createBlock(block, action);
            event.getWhoClicked().sendMessage(this.commandFeedback.sendCommandFeedback("success", true));
            HoneypotPreCreateEvent hce = new HoneypotPreCreateEvent((Player)event.getWhoClicked(), block);
            Bukkit.getPluginManager().callEvent((Event)hce);
        }
    }

    public SGMenu mainMenu(Player p) {
        SGMenu mainMenu = this.plugin.getGUI().create("Honeypot Main Menu", 1);
        ItemBuilder createItem = new ItemBuilder(this.safeGetMaterial(this.configManager.getGuiConfig().getString("main-buttons.create-button")));
        createItem.name("Create a Honeypot");
        ItemBuilder removeItem = new ItemBuilder(this.safeGetMaterial(this.configManager.getGuiConfig().getString("main-buttons.remove-button")));
        removeItem.name("Remove a Honeypot");
        ItemBuilder listItem = new ItemBuilder(this.safeGetMaterial(this.configManager.getGuiConfig().getString("main-buttons.list-button")));
        listItem.name("List all Honeypots");
        ItemBuilder locateItem = new ItemBuilder(this.safeGetMaterial(this.configManager.getGuiConfig().getString("main-buttons.locate-button")));
        locateItem.name("Locate nearby Honeypots");
        ItemBuilder historyItem = new ItemBuilder(this.safeGetMaterial(this.configManager.getGuiConfig().getString("main-buttons.history-button")));
        historyItem.name("Query player history");
        SGButton createButton = new SGButton(createItem.build()).withListener(event -> this.customHoneypotsInventory(p));
        SGButton removeButton = new SGButton(removeItem.build()).withListener(event -> this.removeHoneypotInventory(p));
        SGButton listButton = new SGButton(listItem.build()).withListener(event -> this.allHoneypotsInventory(p));
        SGButton locateButton = new SGButton(locateItem.build()).withListener(event -> {
            event.getWhoClicked().closeInventory();
            if (!p.hasPermission("honeypot.locate")) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("nopermission", new Boolean[0]));
                return;
            }
            int radius = this.configManager.getPluginConfig().getInt("search-range");
            boolean potFound = false;
            List<HoneypotBlockObject> honeypots = Registry.getStorageProvider().getNearbyHoneypots(p.getLocation(), radius);
            if (!honeypots.isEmpty()) {
                potFound = true;
            }
            for (HoneypotBlockObject honeypot : honeypots) {
                Slime slime = (Slime)Objects.requireNonNull(Bukkit.getWorld((String)honeypot.getBlock().getWorld().getName())).spawnEntity(honeypot.getBlock().getLocation().add(0.5, 0.0, 0.5), EntityType.SLIME);
                slime.setSize(2);
                slime.setAI(false);
                slime.setGlowing(true);
                slime.setInvulnerable(true);
                slime.setHealth(slime.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                slime.setInvisible(true);
                slime.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> slime.remove(), null, 100L);
            }
            if (potFound) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("found-pots", new Boolean[0]));
            } else {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("no-pots-found", new Boolean[0]));
            }
        });
        SGButton historyButton = new SGButton(historyItem.build()).withListener(event -> this.historyQueryInventory(p));
        mainMenu.setButton(2, createButton);
        mainMenu.setButton(3, removeButton);
        mainMenu.setButton(4, listButton);
        mainMenu.setButton(5, locateButton);
        mainMenu.setButton(6, historyButton);
        return mainMenu;
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        return new ArrayList<String>();
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.gui"));
        return permissions;
    }

    private Material safeGetMaterial(String materialName) {
        Material material = Material.getMaterial((String)materialName);
        return material != null ? material : Material.PAPER;
    }

    public void callAllHoneypotsInventory(Player p) {
        this.allHoneypotsInventory(p);
    }
}

