/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands.subcommands;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.api.events.HoneypotCreateEvent;
import org.reprogle.honeypot.api.events.HoneypotPreCreateEvent;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.providers.BehaviorProvider;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotPermission;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;
import org.reprogle.honeypot.common.utils.integrations.GriefPreventionAdapter;
import org.reprogle.honeypot.common.utils.integrations.LandsAdapter;
import org.reprogle.honeypot.common.utils.integrations.WorldGuardAdapter;

public class HoneypotCreate
implements HoneypotSubCommand {
    private final CommandFeedback commandFeedback;
    private final HoneypotConfigManager configManager;
    private final HoneypotBlockManager blockManager;
    private final AdapterManager adapterManager;
    private final Honeypot plugin;

    @Inject
    HoneypotCreate(CommandFeedback commandFeedback, HoneypotConfigManager configManager, HoneypotBlockManager blockManager, AdapterManager adapterManager, Honeypot plugin) {
        this.commandFeedback = commandFeedback;
        this.configManager = configManager;
        this.blockManager = blockManager;
        this.adapterManager = adapterManager;
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public void perform(Player p, String[] args) {
        WorldGuardAdapter wga = this.adapterManager.getWorldGuardAdapter();
        GriefPreventionAdapter gpa = this.adapterManager.getGriefPreventionAdapter();
        LandsAdapter la = this.adapterManager.getLandsAdapter();
        if (p.getTargetBlockExact(5) == null) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("not-looking-at-block", new Boolean[0]));
            return;
        }
        Block block = p.getTargetBlockExact(5);
        if (block == null) {
            return;
        }
        if (wga != null && !wga.isAllowed(p, block.getLocation())) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("worldguard", new Boolean[0]));
            return;
        }
        if (gpa != null && !gpa.isAllowed(p, block.getLocation())) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("griefprevention", new Boolean[0]));
            return;
        }
        if (la != null && !la.isAllowed(block.getLocation())) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("lands", new Boolean[0]));
            return;
        }
        if (this.configManager.getPluginConfig().getBoolean("filters.blocks").booleanValue() || this.configManager.getPluginConfig().getBoolean("filters.inventories").booleanValue() && !this.isAllowedPerFilters(block)) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("against-filter", new Boolean[0]));
            return;
        }
        if (this.blockManager.isHoneypotBlock(block)) {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("already-exists", new Boolean[0]));
        } else if (args.length >= 2) {
            HoneypotPreCreateEvent hpce = new HoneypotPreCreateEvent(p, block);
            Bukkit.getPluginManager().callEvent((Event)hpce);
            if (hpce.isCancelled()) {
                return;
            }
            if (args[1].equalsIgnoreCase("custom")) {
                if (!args[2].isEmpty() && this.configManager.getHoneypotsConfig().contains(args[2])) {
                    this.blockManager.createBlock(block, args[2]);
                    p.sendMessage(this.commandFeedback.sendCommandFeedback("success", true));
                } else {
                    p.sendMessage(this.commandFeedback.sendCommandFeedback("no-exist", new Boolean[0]));
                }
            } else {
                this.blockManager.createBlock(block, args[1]);
                p.sendMessage(this.commandFeedback.sendCommandFeedback("success", true));
            }
            HoneypotCreateEvent hce = new HoneypotCreateEvent(p, block);
            Bukkit.getPluginManager().callEvent((Event)hce);
        } else {
            p.sendMessage(this.commandFeedback.sendCommandFeedback("usage", new Boolean[0]));
        }
    }

    @Override
    public List<String> getSubcommands(Player p, String[] args) {
        ArrayList<String> subcommands = new ArrayList<String>();
        if (args.length == 2) {
            ConcurrentMap<String, BehaviorProvider> map = Registry.getBehaviorRegistry().getBehaviorProviders();
            map.forEach((providerName, provider) -> subcommands.add((String)providerName));
            Set keys = this.configManager.getHoneypotsConfig().getKeys();
            for (Object key : keys) {
                subcommands.add(key.toString());
            }
        }
        return subcommands;
    }

    @Override
    public List<HoneypotPermission> getRequiredPermissions() {
        ArrayList<HoneypotPermission> permissions = new ArrayList<HoneypotPermission>();
        permissions.add(new HoneypotPermission("honeypot.create"));
        return permissions;
    }

    private boolean isAllowedPerFilters(Block block) {
        List allowedBlocks = this.configManager.getPluginConfig().getStringList("allowed-blocks");
        List allowedInventories = this.configManager.getPluginConfig().getStringList("allowed-inventories");
        boolean allowed = false;
        if (this.configManager.getPluginConfig().getBoolean("filters.blocks").booleanValue()) {
            for (String blockType : allowedBlocks) {
                assert (block != null);
                if (!block.getType().name().equals(blockType)) continue;
                allowed = true;
                break;
            }
        }
        if (this.configManager.getPluginConfig().getBoolean("filters.inventories").booleanValue()) {
            for (String blockType : allowedInventories) {
                if (!block.getType().name().equals(blockType)) continue;
                allowed = true;
                break;
            }
        }
        return allowed;
    }
}

