/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.storagemanager.CacheManager;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.utils.GhostHoneypotFixer;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.HoneypotPermission;

@Singleton
public class CommandManager
implements TabExecutor {
    private final Honeypot plugin;
    private final HoneypotLogger logger;
    private final CommandFeedback commandFeedback;
    private final HoneypotConfigManager configManager;
    private final GhostHoneypotFixer fixer;
    @Inject
    private Set<HoneypotSubCommand> subcommands;

    @Inject
    public CommandManager(Honeypot plugin, HoneypotLogger logger, GhostHoneypotFixer fixer, HoneypotConfigManager configManager, CommandFeedback commandFeedback) {
        this.plugin = plugin;
        this.logger = logger;
        this.fixer = fixer;
        this.configManager = configManager;
        this.commandFeedback = commandFeedback;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!(p.hasPermission("honeypot.commands") || p.hasPermission("honeypot.*") || p.isOp())) {
                p.sendMessage(this.commandFeedback.sendCommandFeedback("no-permission", new Boolean[0]));
            }
            if (args.length > 0) {
                for (HoneypotSubCommand subcommand : this.subcommands) {
                    if (!args[0].equalsIgnoreCase(subcommand.getName())) continue;
                    try {
                        if (!this.checkPermissions(p, subcommand).booleanValue()) {
                            p.sendMessage(this.commandFeedback.sendCommandFeedback("no-permission", new Boolean[0]));
                            return false;
                        }
                        subcommand.perform(p, args);
                        return true;
                    }
                    catch (IOException e) {
                        this.logger.severe((Component)Component.text((String)("Error while running command " + args[0] + "! Full stack trace: " + String.valueOf(e))));
                    }
                }
                p.sendMessage(this.commandFeedback.sendCommandFeedback("usage", new Boolean[0]));
            } else {
                for (HoneypotSubCommand subcommand : this.subcommands) {
                    if (!subcommand.getName().equals("gui")) continue;
                    try {
                        if (!this.checkPermissions(p, subcommand).booleanValue()) {
                            p.sendMessage(this.commandFeedback.sendCommandFeedback("no-permission", new Boolean[0]));
                            return false;
                        }
                        subcommand.perform(p, args);
                        return true;
                    }
                    catch (IOException e) {
                        this.logger.severe((Component)Component.text((String)("Error while running command! Full stack trace: " + String.valueOf(e))));
                    }
                }
            }
        } else if (args.length > 0 && args[0].equals("reload")) {
            try {
                this.configManager.getPluginConfig().reload();
                this.configManager.getPluginConfig().save();
                this.configManager.getGuiConfig().reload();
                this.configManager.getGuiConfig().save();
                this.configManager.getHoneypotsConfig().reload();
                this.configManager.getHoneypotsConfig().save();
                this.configManager.getLanguageFile().reload();
                this.configManager.getLanguageFile().save();
                this.fixer.cancelTask();
                if (this.configManager.getPluginConfig().getBoolean("ghost-honeypot-checker.enable").booleanValue()) {
                    this.fixer.startTask();
                }
                CacheManager.clearCache();
                String providerName = this.configManager.getPluginConfig().getString("storage-method");
                if (!Registry.getStorageProvider().getProviderName().equalsIgnoreCase(providerName)) {
                    StorageProvider provider = Registry.getStorageManagerRegistry().getStorageProvider(providerName);
                    if (provider != null) {
                        if (!this.configManager.getPluginConfig().getBoolean("allow-third-party-storage-providers").booleanValue()) {
                            this.logger.severe((Component)Component.text((String)"The storage method was updated to a custom provider, but the server is not configured to allow third-party storage providers! On your next reboot Honeypot WILL crash ON PURPOSE! Please validate your config"));
                        }
                        Registry.setStorageProvider(provider);
                        this.logger.info((Component)Component.text((String)("The storage provider was updated to \"" + providerName + "\"")));
                    } else {
                        this.logger.severe((Component)Component.text((String)("The storage provider was updated to \"" + providerName + "\" but it is not registered! On your next reboot Honeypot WILL crash ON PURPOSE! Please validate your config")));
                    }
                }
                sender.sendMessage(this.commandFeedback.sendCommandFeedback("reload", new Boolean[0]));
                this.logger.info((Component)Component.text((String)"Honeypot has successfully been reloaded"));
            }
            catch (IOException e) {
                this.logger.severe((Component)Component.text((String)("Could not reload honeypot config! Full stack trace: " + String.valueOf(e))));
            }
        } else {
            ConsoleCommandSender console = this.plugin.getServer().getConsoleSender();
            console.sendMessage(this.commandFeedback.buildSplash(this.plugin));
            console.sendMessage(this.commandFeedback.getChatPrefix().append((Component)Component.text((String)("Honeypot running on Paper version " + Bukkit.getVersion()))));
            this.plugin.checkIfServerSupported();
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Player p = (Player)sender;
        if (p.hasPermission("honeypot.commands") || p.hasPermission("honeypot.*") || p.isOp()) {
            if (args.length == 1) {
                ArrayList<String> subcommandsTabComplete = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[0], List.of((String[])this.subcommands.stream().map(HoneypotSubCommand::getName).toArray(String[]::new)), subcommandsTabComplete);
                return subcommandsTabComplete;
            }
            if (args.length >= 2) {
                for (HoneypotSubCommand subcommand : this.subcommands) {
                    if (!args[0].equalsIgnoreCase(subcommand.getName())) continue;
                    ArrayList<String> subcommandsTabComplete = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[args.length - 1], subcommand.getSubcommands(p, args), subcommandsTabComplete);
                    return subcommandsTabComplete;
                }
            }
        }
        return null;
    }

    private Boolean checkPermissions(Player p, HoneypotSubCommand subcommand) {
        boolean allowed = false;
        if (subcommand.getRequiredPermissions().isEmpty()) {
            return true;
        }
        for (HoneypotPermission permission : subcommand.getRequiredPermissions()) {
            if (!p.hasPermission(permission.permission())) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    @Generated
    public Set<HoneypotSubCommand> getSubcommands() {
        return this.subcommands;
    }
}

