/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import dev.dejvokep.boostedyaml.YamlDocument;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;

@Singleton
public class CommandFeedback {
    public static final MiniMessage mm = MiniMessage.miniMessage();
    @Inject
    private HoneypotConfigManager configManager;

    public Component sendCommandFeedback(String feedback, Boolean ... success) {
        Component feedbackMessage;
        Component chatPrefix = this.getChatPrefix();
        YamlDocument languageFile = this.configManager.getLanguageFile();
        switch (feedback.toLowerCase()) {
            case "usage": {
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\n \n \n \n \n \n-----------------------\n \n").color((TextColor)NamedTextColor.WHITE)).append(chatPrefix)).append((Component)Component.text((String)"Need help?\n\n", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" /honeypot ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"remove (all | near) (optional)\n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)" /honeypot ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"reload\n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)" /honeypot ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"locate\n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)" /honeypot ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"gui\n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)" /honeypot ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"history [query | delete | purge] \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"-----------------------", (TextColor)NamedTextColor.WHITE))).build();
                break;
            }
            case "success": {
                if (success.length > 0 && success[0].equals(true)) {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("success.created"))));
                    break;
                }
                if (success.length > 0 && success[0].equals(false)) {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("success.removed"))));
                    break;
                }
                feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("success.default"))));
                break;
            }
            case "debug": {
                if (success.length > 0 && success[0].equals(true)) {
                    feedbackMessage = chatPrefix.append((Component)Component.text((String)"Debug mode has been enabled. Right click any block to check its PDC"));
                    break;
                }
                if (success.length > 0 && success[0].equals(false)) {
                    feedbackMessage = chatPrefix.append((Component)Component.text((String)"Debug mode has been disabled"));
                    break;
                }
                feedbackMessage = chatPrefix.append((Component)Component.text((String)"Debug mode is only useful while using PDC"));
                break;
            }
            case "migrate": {
                if (success.length > 0 && success[0].equals(true)) {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("migrate.confirm"))));
                    break;
                }
                if (success.length > 0 && success[0].equals(false)) {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("migrate.failed"))));
                    break;
                }
                feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("migrate.preconfirm"))));
                break;
            }
            case "deleted": {
                if (success.length > 0 && success[0].equals(true)) {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("deleted.all"))));
                    break;
                }
                feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("deleted.near"))));
                break;
            }
            default: {
                try {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString(feedback.toLowerCase()))));
                    break;
                }
                catch (Exception e) {
                    feedbackMessage = chatPrefix.append(Component.text().append(mm.deserialize((Object)languageFile.getString("unknown-error"))));
                }
            }
        }
        return feedbackMessage;
    }

    public Component getChatPrefix() {
        return mm.deserialize((Object)Objects.requireNonNull(this.configManager.getLanguageFile().getString("prefix")));
    }

    public Component buildSplash(Honeypot plugin) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\n").append((Component)Component.text((String)" _____                         _\n", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"|  |  |___ ___ ___ _ _ ___ ___| |_\n", (TextColor)NamedTextColor.GOLD))).append(Component.text((String)"|     | . |   | -_| | | . | . |  _|    by", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)" TerrorByte\n", (TextColor)NamedTextColor.RED)))).append(Component.text((String)"|__|__|___|_|_|___|_  |  _|___|_|      version ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)(plugin.getPluginMeta().getVersion() + "\n"), (TextColor)NamedTextColor.RED)))).append((Component)Component.text((String)"                  |___|_|", (TextColor)NamedTextColor.GOLD))).build();
    }
}

