/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.reprogle.honeypot.common.storageproviders.HoneypotStore;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.storageproviders.exceptions.InvalidStorageManagerDefinitionException;
import org.reprogle.honeypot.common.storageproviders.exceptions.StorageManagerConflictException;

public class HoneypotStoreRegistry {
    protected final ConcurrentMap<String, StorageProvider> storageProviders = Maps.newConcurrentMap();
    private final Object lock = new Object();
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NotNull StorageProvider storageProvider) {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                throw new IllegalStateException("New storage providers cannot be registered at this time");
            }
            try {
                this.forceRegister(storageProvider);
            }
            catch (InvalidStorageManagerDefinitionException | StorageManagerConflictException e) {
                Logger.getLogger("minecraft").warning(e.getMessage());
                Logger.getLogger("minecraft").warning("An error occurred while registering a behavior. Please see details above!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageProvider forceRegister(StorageProvider provider) throws InvalidStorageManagerDefinitionException, StorageManagerConflictException {
        Object object = this.lock;
        synchronized (object) {
            if (!provider.getClass().isAnnotationPresent(HoneypotStore.class)) {
                throw new InvalidStorageManagerDefinitionException("Storage manager " + provider.getClass().getName().toLowerCase() + " is improperly defined, and therefore cannot be registered. Please contact the author of the plugin attempting to register this provider");
            }
            if (this.storageProviders.containsKey(provider.getProviderName().toLowerCase())) {
                throw new StorageManagerConflictException("Storage manager " + provider.getClass().getName().toLowerCase() + " is already registered under that name. Please rename the Behavior");
            }
            return this.storageProviders.put(provider.getProviderName().toLowerCase(), provider);
        }
    }

    public StorageProvider getStorageProvider(@NotNull String name) {
        return (StorageProvider)this.storageProviders.get(name.toLowerCase());
    }

    public ConcurrentMap<String, StorageProvider> getStorageProviders() {
        return this.storageProviders;
    }

    public int size() {
        return this.storageProviders.size();
    }
}

