/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.HoneypotSubCommand;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotCreate;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotGUI;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotHelp;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotHistory;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotInfo;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotList;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotLocate;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotMigrate;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotReload;
import org.reprogle.honeypot.common.commands.subcommands.HoneypotRemove;
import org.reprogle.honeypot.common.providers.BehaviorProvider;
import org.reprogle.honeypot.common.providers.included.Ban;
import org.reprogle.honeypot.common.providers.included.Kick;
import org.reprogle.honeypot.common.providers.included.Notify;
import org.reprogle.honeypot.common.providers.included.Warn;
import org.reprogle.honeypot.common.storagemanager.pdc.DataStoreManager;
import org.reprogle.honeypot.common.storagemanager.sqlite.SQLite;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;

public class HoneypotModule
extends AbstractModule {
    private final Honeypot plugin;
    private final HoneypotConfigManager configManager;
    private final CommandFeedback commandFeedback;

    public HoneypotModule(Honeypot plugin, HoneypotConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        configManager.setupConfig((Plugin)plugin);
        this.commandFeedback = new CommandFeedback();
    }

    protected void configure() {
        this.bind(Honeypot.class).toInstance((Object)this.plugin);
        this.bind(HoneypotConfigManager.class).toInstance((Object)this.configManager);
        this.bind(CommandFeedback.class).toInstance((Object)this.commandFeedback);
        Multibinder behaviorBinder = Multibinder.newSetBinder((Binder)this.binder(), BehaviorProvider.class);
        behaviorBinder.addBinding().to(Ban.class);
        behaviorBinder.addBinding().to(Warn.class);
        behaviorBinder.addBinding().to(Kick.class);
        behaviorBinder.addBinding().to(Notify.class);
        Multibinder storageBinder = Multibinder.newSetBinder((Binder)this.binder(), StorageProvider.class);
        storageBinder.addBinding().to(SQLite.class);
        storageBinder.addBinding().to(DataStoreManager.class);
        Multibinder subcommandBinder = Multibinder.newSetBinder((Binder)this.binder(), HoneypotSubCommand.class);
        subcommandBinder.addBinding().to(HoneypotCreate.class);
        subcommandBinder.addBinding().to(HoneypotRemove.class);
        subcommandBinder.addBinding().to(HoneypotReload.class);
        subcommandBinder.addBinding().to(HoneypotLocate.class);
        subcommandBinder.addBinding().to(HoneypotGUI.class);
        subcommandBinder.addBinding().to(HoneypotHelp.class);
        subcommandBinder.addBinding().to(HoneypotInfo.class);
        subcommandBinder.addBinding().to(HoneypotHistory.class);
        subcommandBinder.addBinding().to(HoneypotList.class);
        subcommandBinder.addBinding().to(HoneypotMigrate.class);
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"HoneypotLogFile")).toInstance((Object)new File(this.plugin.getDataFolder(), "honeypot.log"));
    }

    public Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{this});
    }
}

