/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Set;
import javax.naming.ConfigurationException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.reprogle.honeypot.HoneypotModule;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.commands.CommandManager;
import org.reprogle.honeypot.common.events.Listeners;
import org.reprogle.honeypot.common.libs.bstats.bukkit.Metrics;
import org.reprogle.honeypot.common.libs.spigui.spigui.SpiGUI;
import org.reprogle.honeypot.common.providers.BehaviorProvider;
import org.reprogle.honeypot.common.storagemanager.CacheManager;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.utils.GhostHoneypotFixer;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.HoneypotSupportedVersions;
import org.reprogle.honeypot.common.utils.HoneypotUpdateChecker;
import org.reprogle.honeypot.common.utils.integrations.AdapterManager;

public final class Honeypot
extends JavaPlugin {
    private static SpiGUI gui;
    @Inject
    private AdapterManager adapterManager;
    @Inject
    private Listeners listeners;
    @Inject
    private CommandManager manager;
    @Inject
    private HoneypotLogger logger;
    @Inject
    private GhostHoneypotFixer ghf;
    @Inject
    private CommandFeedback commandFeedback;
    @Inject
    private Set<BehaviorProvider> behaviorProviders;
    @Inject
    private Set<StorageProvider> storageProviders;
    @Inject
    private HoneypotConfigManager configManager;
    private Injector injector;

    public void onLoad() {
        HoneypotConfigManager configManager = new HoneypotConfigManager();
        HoneypotModule module = new HoneypotModule(this, configManager);
        this.injector = module.createInjector();
        this.injector.injectMembers((Object)this);
        this.adapterManager.onLoadAdapters(this.getServer());
        for (BehaviorProvider behavior : this.behaviorProviders) {
            Registry.getBehaviorRegistry().register(behavior);
        }
        for (StorageProvider provider : this.storageProviders) {
            Registry.getStorageManagerRegistry().register(provider);
        }
    }

    public void onEnable() {
        gui = new SpiGUI(this);
        Registry.getBehaviorRegistry().setInitialized(true);
        Registry.getStorageManagerRegistry().setInitialized(true);
        this.ghf.startTask();
        String storageMethod = this.configManager.getPluginConfig().getString("storage-method");
        if (!(storageMethod.equals("sqlite") || storageMethod.equals("pdc") || this.configManager.getPluginConfig().getBoolean("allow-third-party-storage-managers").booleanValue())) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.logger.severe((Component)Component.text((String)"THE PLUGIN WAS PURPOSELY SHUT DOWN, THIS IS NOT A BUG. YOUR CONFIGURATION IS INVALID, CHECK IT BEFORE REPORTING TO THE DEVELOPER!"));
            throw new ConfigurationException(this.configManager.getLanguageFile().getString("storage-providers-not-enabled"));
        }
        if (Registry.getStorageManagerRegistry().getStorageProvider(storageMethod) == null) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.logger.severe((Component)Component.text((String)"THE PLUGIN WAS PURPOSELY SHUT DOWN, THIS IS NOT A BUG. THE STORAGE PROVIDER IS NOT CORRECTLY DEFINED, CHECK WITH THE DEVELOPER OF THE PROVIDER!"));
            throw new ConfigurationException(this.configManager.getLanguageFile().getString("invalid-storage-provider").replace("%s", storageMethod));
        }
        Registry.setStorageProvider(Registry.getStorageManagerRegistry().getStorageProvider(storageMethod));
        this.getHoneypotLogger().info((Component)Component.text((String)("Successfully registered " + Registry.getBehaviorRegistry().size() + " behavior providers. Further registrations are now locked.")));
        this.getHoneypotLogger().info((Component)Component.text((String)(Registry.getStorageManagerRegistry().size() + " storage providers have been registered, the one Honeypot is configured to use is: " + Registry.getStorageProvider().getProviderName() + ". Further registrations are now locked, but the provider can be changed at any time by doing /honeypot reload.")));
        new Metrics((Plugin)this, 15425);
        this.listeners.setupListeners();
        this.adapterManager.onEnableAdapters(this.getServer());
        this.getCommand("honeypot").setExecutor((CommandExecutor)this.manager);
        this.getServer().getConsoleSender().sendMessage(this.commandFeedback.buildSplash(this));
        if (this.isFolia()) {
            this.getHoneypotLogger().warning((Component)Component.text((String)"Welcome to Folia!!!! It is assumed you know what you're doing, since Folia is not yet standard. While Honeypot can run on Folia, it is not yet officially endorsed by the developer, and is also not actively tested. Be wary when using it for now, and report any bugs in Honeypot caused by Folia to the developer!"));
        }
        this.checkIfServerSupported();
        new HoneypotUpdateChecker((Plugin)this, "https://raw.githubusercontent.com/TerrorByteTW/Honeypot/master/version.txt").getVersion(latest -> {
            if (Integer.parseInt(latest.replace(".", "")) > Integer.parseInt(this.getPluginMeta().getVersion().replace(".", ""))) {
                this.getServer().getConsoleSender().sendMessage(this.commandFeedback.getChatPrefix().append((Component)Component.text((String)("There is a new update available: " + latest + ". Download for the latest features and performance improvements!"), (TextColor)NamedTextColor.RED)));
            } else {
                this.getServer().getConsoleSender().sendMessage(this.commandFeedback.getChatPrefix().append((Component)Component.text((String)"You are on the latest version of Honeypot!", (TextColor)NamedTextColor.GREEN)));
            }
        }, this.logger);
    }

    public void onDisable() {
        this.getHoneypotLogger().info((Component)Component.text((String)"Stopping the ghost checker task"));
        this.ghf.cancelTask();
        CacheManager.clearCache();
        this.getHoneypotLogger().info((Component)Component.text((String)"Successfully shutdown Honeypot. Bye for now!"));
    }

    public void checkIfServerSupported() {
        String[] serverVersion = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        int serverMajorVer = Integer.parseInt(serverVersion[0]);
        int serverMinorVer = Integer.parseInt(serverVersion[1]);
        int serverRevisionVer = serverVersion.length > 2 ? Integer.parseInt(serverVersion[2]) : 0;
        String pluginVersion = this.getPluginMeta().getVersion();
        new HoneypotSupportedVersions((Plugin)this, pluginVersion).getSupportedVersions(value -> {
            int upperRevisionVer;
            if (value.pulled()) {
                this.getHoneypotLogger().warning((Component)Component.text((String)value.message()));
                return;
            }
            String[] lowerVersion = value.message().split("-")[0].split("\\.");
            String[] upperVersion = value.message().split("-")[1].split("\\.");
            int lowerMajorVer = Integer.parseInt(lowerVersion[0]);
            int lowerMinorVer = Integer.parseInt(lowerVersion[1]);
            int lowerRevisionVer = lowerVersion.length > 2 ? Integer.parseInt(lowerVersion[2]) : 0;
            int upperMajorVer = Integer.parseInt(upperVersion[0]);
            int upperMinorVer = Integer.parseInt(upperVersion[1]);
            int n = upperRevisionVer = lowerVersion.length > 2 ? Integer.parseInt(upperVersion[2]) : 0;
            if (!(serverMajorVer >= lowerMajorVer && serverMajorVer <= upperMajorVer || serverMinorVer >= lowerMinorVer && serverMinorVer < upperMinorVer || serverRevisionVer >= lowerRevisionVer && serverRevisionVer <= upperRevisionVer)) {
                this.getHoneypotLogger().warning((Component)Component.text((String)"Honeypot is not guaranteed to support this version of Minecraft. We won't prevent you from using it, but functionality is not guaranteed. If you experience any issues please report them to the developer."));
                this.getHoneypotLogger().warning((Component)Component.text((String)("Honeypot " + pluginVersion + " supports server versions " + String.valueOf(value))));
            }
        }, this.logger);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public SpiGUI getGUI() {
        return gui;
    }

    public HoneypotLogger getHoneypotLogger() {
        return this.logger;
    }

    private boolean isFolia() {
        return Bukkit.getServer().getName().startsWith("Folia");
    }
}

