/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.reprogle.honeypot.common.providers.Behavior;
import org.reprogle.honeypot.common.providers.BehaviorProvider;
import org.reprogle.honeypot.common.providers.exceptions.BehaviorConflictException;
import org.reprogle.honeypot.common.providers.exceptions.InvalidBehaviorDefinitionException;

public class BehaviorRegistry {
    private boolean initialized = false;
    private final Object lock = new Object();
    protected final ConcurrentMap<String, BehaviorProvider> behaviorProviders = Maps.newConcurrentMap();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NotNull BehaviorProvider behavior) {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                throw new IllegalStateException("New behaviors cannot be registered at this time");
            }
            try {
                this.forceRegister(behavior);
            }
            catch (BehaviorConflictException | InvalidBehaviorDefinitionException e) {
                Logger.getLogger("minecraft").warning(e.getMessage());
                Logger.getLogger("minecraft").warning("An error occurred while registering a behavior. Please see details above!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BehaviorProvider forceRegister(BehaviorProvider behavior) throws InvalidBehaviorDefinitionException, BehaviorConflictException {
        Object object = this.lock;
        synchronized (object) {
            if (!behavior.getClass().isAnnotationPresent(Behavior.class)) {
                throw new InvalidBehaviorDefinitionException("Behavior " + behavior.getClass().getName().toLowerCase() + " is improperly defined, and therefore cannot be registered. Please contact the author of the plugin attempting to register this provider");
            }
            if (this.behaviorProviders.containsKey(behavior.getProviderName().toLowerCase())) {
                throw new BehaviorConflictException("Behavior " + behavior.getClass().getName().toLowerCase() + " is already registered under that name. Please rename the Behavior");
            }
            return this.behaviorProviders.put(behavior.getProviderName().toLowerCase(), behavior);
        }
    }

    public BehaviorProvider getBehaviorProvider(@NotNull String name) {
        return (BehaviorProvider)this.behaviorProviders.get(name.toLowerCase());
    }

    public ConcurrentMap<String, BehaviorProvider> getBehaviorProviders() {
        return this.behaviorProviders;
    }

    public int size() {
        return this.behaviorProviders.size();
    }
}

