/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.store.Database;
import org.reprogle.dimensionpause.utils.DimensionState;
import org.reprogle.dimensionpause.utils.WorldUtils;

@Singleton
public class DimensionExpirationTimer {
    private final Map<String, Instant> expirations = new HashMap<String, Instant>();
    private ScheduledTask nextTask;
    @Inject
    DimensionState state;
    @Inject
    DimensionPausePlugin plugin;

    public void refresh() {
        this.expirations.clear();
        this.setExpirations();
        this.scheduleNext();
    }

    private void setExpirations() {
        Set bases = Bukkit.getWorlds().stream().map(WorldUtils::getOverworld).filter(Objects::nonNull).collect(Collectors.toSet());
        Instant now = Instant.now();
        for (World base : bases) {
            for (World.Environment env : new World.Environment[]{World.Environment.NETHER, World.Environment.THE_END}) {
                Database.WorldPauseStatus status = this.state.getState(base, env);
                Instant exp = status.expiresAt();
                if (exp == null || !exp.isAfter(now) || status.enabled()) continue;
                this.plugin.getLogger().info("Monitoring world pause expiration for world: " + base.getName() + " " + String.valueOf(env));
                this.expirations.put(base.getName() + ":" + env.name(), exp);
            }
        }
    }

    private void scheduleNext() {
        Map.Entry next;
        if (this.nextTask != null) {
            this.nextTask.cancel();
            this.nextTask = null;
        }
        if ((next = (Map.Entry)this.expirations.entrySet().stream().min(Map.Entry.comparingByValue()).orElse(null)) == null) {
            return;
        }
        long ticks = Math.max(1L, Duration.between(Instant.now(), (Temporal)next.getValue()).toSeconds() * 20L);
        this.nextTask = Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> {
            this.expireDue();
            this.scheduleNext();
        }, ticks);
    }

    private void expireDue() {
        Instant now = Instant.now();
        List<Map.Entry> due = this.expirations.entrySet().stream().filter(e -> !((Instant)e.getValue()).isAfter(now)).toList();
        for (Map.Entry e2 : due) {
            this.expirations.remove(e2.getKey());
            String[] parts = ((String)e2.getKey()).split(":", 2);
            String worldName = parts[0];
            World.Environment env = World.Environment.valueOf((String)parts[1]);
            World base = Bukkit.getWorld((String)worldName);
            if (base == null) continue;
            this.plugin.getLogger().info("Expiring pause for for world: " + base.getName() + " " + String.valueOf(env));
            this.state.setDimensionState(base, env, DimensionState.State.ENABLED);
        }
    }
}

