/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.commands;

import com.google.inject.Inject;
import dev.dejvokep.boostedyaml.YamlDocument;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nullable;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.World;
import org.reprogle.dimensionpause.store.Database;
import org.reprogle.dimensionpause.utils.ConfigManager;
import org.reprogle.dimensionpause.utils.DimensionState;

public class CommandFeedback {
    public static final MiniMessage mm = MiniMessage.miniMessage();
    @Inject
    private ConfigManager configManager;
    @Inject
    private DimensionState state;

    public Component sendCommandFeedback(String feedback, @Nullable World world, @Nullable String dimension) {
        Component feedbackMessage;
        YamlDocument languageFile = this.configManager.getLanguageFile();
        World.Environment environment = null;
        if (dimension != null && (dimension.equalsIgnoreCase("end") || dimension.equalsIgnoreCase("nether"))) {
            environment = dimension.equalsIgnoreCase("nether") ? World.Environment.NETHER : World.Environment.THE_END;
        }
        Component untilComponent = mm.deserialize((Object)languageFile.getString("state.until"));
        switch (feedback.toLowerCase()) {
            case "usage": {
                Component prefixComponent = mm.deserialize((Object)languageFile.getString("state.until"));
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\n \n \n \n \n \n-----------------------\n \n").color((TextColor)NamedTextColor.WHITE)).append(prefixComponent)).append((Component)Component.text((String)" "))).append((Component)Component.text((String)"Need help?\n \n", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"  /dimensionpause ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"toggle <world> <end | nether> [<weeks>w][<days>d][<hours>h][<minutes>m][<seconds>s] \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"  /dimensionpause ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"state <world> <end | nether> \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"  /dimensionpause ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"reload \n \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"-----------------------", (TextColor)NamedTextColor.WHITE))).build();
                break;
            }
            case "nopermission": {
                feedbackMessage = this.deserialize(languageFile.getString("no-permission"), false, null);
                break;
            }
            case "reload": {
                feedbackMessage = this.deserialize(languageFile.getString("reload"), false, null);
                break;
            }
            case "io-exception": {
                feedbackMessage = this.deserialize(languageFile.getString("io-exception"), false, null);
                break;
            }
            case "newstate": {
                if (environment == null || world == null) {
                    feedbackMessage = this.deserialize(languageFile.getString("toggled.default"), false, null);
                    break;
                }
                Database.WorldPauseStatus worldState = this.state.getState(world, environment);
                TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(this.deserialize(languageFile.getString("toggled." + dimension), worldState.enabled(), world.getName()));
                if (worldState.expiresAt() != null && !worldState.enabled()) {
                    ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)" "))).append(untilComponent)).append((Component)Component.text((String)" "))).append((Component)Component.text((String)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC).format(worldState.expiresAt())))).append((Component)Component.text((String)" UTC"));
                }
                feedbackMessage = builder.build();
                break;
            }
            case "state": {
                if (environment == null || world == null) {
                    return Component.empty();
                }
                Database.WorldPauseStatus worldState = this.state.getState(world, environment);
                TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(this.deserialize(languageFile.getString("state." + dimension), worldState.enabled(), world.getName()));
                if (worldState.expiresAt() != null && !worldState.enabled()) {
                    ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)" "))).append(untilComponent)).append((Component)Component.text((String)" "))).append((Component)Component.text((String)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC).format(worldState.expiresAt())))).append((Component)Component.text((String)" UTC"));
                }
                feedbackMessage = builder.build();
                break;
            }
            default: {
                feedbackMessage = this.deserialize(languageFile.getString("unknown-error"), false, null);
            }
        }
        return feedbackMessage;
    }

    public Title getTitleForDimension(World.Environment env) {
        String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        BuildableComponent mainTitle = ((TextComponent.Builder)Component.text().append(mm.deserialize((Object)this.configManager.getLanguageFile().getString("alert." + environment + ".title.title")))).build();
        BuildableComponent subtitle = ((TextComponent.Builder)Component.text().append(mm.deserialize((Object)this.configManager.getLanguageFile().getString("alert." + environment + ".title.subtitle")))).build();
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L));
        return Title.title((Component)mainTitle, (Component)subtitle, (Title.Times)times);
    }

    public Title getTitleForTeleport(int secondsRemaining, boolean fadeInTitle) {
        NamedTextColor numColor = secondsRemaining >= 3 ? NamedTextColor.GOLD : (secondsRemaining == 2 ? NamedTextColor.RED : NamedTextColor.DARK_RED);
        BuildableComponent mainTitle = ((TextComponent.Builder)Component.text().append(mm.deserialize((Object)this.configManager.getLanguageFile().getString("preteleport.title")))).build();
        BuildableComponent subtitle = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(mm.deserialize((Object)this.configManager.getLanguageFile().getString("preteleport.subtitle")))).append((Component)Component.text((int)secondsRemaining, (TextColor)numColor))).build();
        return Title.title((Component)mainTitle, (Component)subtitle, (Title.Times)Title.Times.times((Duration)(fadeInTitle ? Duration.ofMillis(500L) : Duration.ZERO), (Duration)Duration.ofMillis(1000L), (Duration)Duration.ZERO));
    }

    public Component getDimensionIsPausedMessage(World.Environment env) {
        String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        return this.deserialize(this.configManager.getLanguageFile().getString("alert." + environment + ".chat"), false, null);
    }

    public Component getStateChangedMessage(World world, World.Environment env, boolean enabled) {
        return this.getStateChangedMessage(world.getName(), env, enabled);
    }

    public Component getStateChangedMessage(String world, World.Environment env, boolean enabled) {
        String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        return this.deserialize(this.configManager.getLanguageFile().getString("alert." + environment + ".on-toggle"), enabled, world);
    }

    private Component deserialize(String serializedString, boolean worldState, String worldName) {
        Component prefixComponent = mm.deserialize((Object)this.configManager.getLanguageFile().getString("prefix"));
        Component pausedComponent = mm.deserialize((Object)this.configManager.getLanguageFile().getString("state.paused"));
        Component unpausedComponent = mm.deserialize((Object)this.configManager.getLanguageFile().getString("state.unpaused"));
        return mm.deserialize(serializedString, new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)prefixComponent), Placeholder.component((String)"state", (ComponentLike)(worldState ? unpausedComponent : pausedComponent)), Placeholder.component((String)"world", (ComponentLike)Component.text((String)(worldName != null ? worldName : ""), (TextColor)NamedTextColor.BLUE))});
    }
}

