/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.utils;

import java.time.Instant;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstantParser {
    private static final Pattern DURATION_PART = Pattern.compile("(\\d+)([wdhms])", 2);
    private static final List<Character> ORDER = List.of(Character.valueOf('w'), Character.valueOf('d'), Character.valueOf('h'), Character.valueOf('m'), Character.valueOf('s'));

    public static Instant parseFutureInstant(String input) {
        input = input.toLowerCase().trim();
        Matcher matcher = DURATION_PART.matcher(input);
        int lastOrderIndex = -1;
        long totalSeconds = 0L;
        int matchedLength = 0;
        while (matcher.find()) {
            long value = Long.parseLong(matcher.group(1));
            char unit = matcher.group(2).charAt(0);
            int orderIndex = ORDER.indexOf(Character.valueOf(unit));
            if (orderIndex == -1) {
                throw new IllegalArgumentException("Invalid time unit: " + unit);
            }
            if (orderIndex <= lastOrderIndex) {
                throw new IllegalArgumentException("Invalid duration order");
            }
            lastOrderIndex = orderIndex;
            matchedLength += matcher.group(0).length();
            totalSeconds += (switch (unit) {
                case 'w' -> value * 7L * 24L * 60L * 60L;
                case 'd' -> value * 24L * 60L * 60L;
                case 'h' -> value * 60L * 60L;
                case 'm' -> value * 60L;
                case 's' -> value;
                default -> 0L;
            });
        }
        if (matchedLength != input.length()) {
            throw new IllegalArgumentException("Invalid duration format");
        }
        if (totalSeconds <= 0L) {
            throw new IllegalArgumentException("Duration must be greater than zero");
        }
        return Instant.now().plusSeconds(totalSeconds);
    }
}

