/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import com.google.inject.Inject;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.utils.ConfigManager;
import org.reprogle.dimensionpause.utils.DimensionState;

public class PortalCreateEventListener
implements Listener {
    @Inject
    DimensionState state;
    @Inject
    ConfigManager configManager;
    @Inject
    CommandFeedback commandFeedback;

    @EventHandler
    public void onPortalCreateEvent(PortalCreateEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (p.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return;
        }
        if (this.state.getState(p.getWorld(), World.Environment.NETHER).enabled()) {
            return;
        }
        if (event.getReason().equals((Object)PortalCreateEvent.CreateReason.FIRE) && !this.state.getState(p.getWorld(), World.Environment.NETHER).enabled()) {
            if (this.state.canBypass(p, p.getWorld(), World.Environment.NETHER)) {
                return;
            }
            event.setCancelled(true);
            boolean sendTitle = this.configManager.getPluginConfig().getBoolean("dimensions.nether.alert.title");
            boolean sendChat = this.configManager.getPluginConfig().getBoolean("dimensions.nether.alert.chat");
            if (sendTitle) {
                p.showTitle(this.commandFeedback.getTitleForDimension(World.Environment.NETHER));
            }
            if (sendChat) {
                p.sendMessage(this.commandFeedback.getDimensionIsPausedMessage(World.Environment.NETHER));
            }
        }
    }
}

