/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import com.google.inject.Inject;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.utils.DimensionState;
import org.reprogle.dimensionpause.utils.WorldUtils;

public class PlayerTeleportEventListener
implements Listener {
    @Inject
    DimensionState state;
    @Inject
    DimensionPausePlugin plugin;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getFrom().getWorld().equals((Object)event.getTo().getWorld())) {
            return;
        }
        World.Environment env = event.getTo().getWorld().getEnvironment();
        Player p = event.getPlayer();
        if (env.equals((Object)World.Environment.NORMAL)) {
            return;
        }
        World fromOverworld = WorldUtils.getOverworld(event.getFrom().getWorld());
        if (!this.state.getState(fromOverworld, env).enabled()) {
            if (this.state.canBypass(p, fromOverworld, env)) {
                return;
            }
            event.setCancelled(true);
            this.state.alertPlayer(p, env);
            Location base = event.getPlayer().getLocation().clone().add(0.0, 0.1, 0.0);
            this.risingSmoke(p, base, 0, 10);
        }
    }

    private void risingSmoke(Player p, Location base, int step, int maxSteps) {
        if (!p.isOnline() || step > maxSteps) {
            return;
        }
        Location loc = base.clone().add(0.0, (double)step * 0.15, 0.0);
        loc.getWorld().spawnParticle(Particle.LARGE_SMOKE, loc, 8, 0.2, 0.05, 0.2, 0.01);
        p.getScheduler().runDelayed((Plugin)this.plugin, t -> this.risingSmoke(p, base, step + 1, maxSteps), null, 1L);
    }
}

