/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.commands.subcommands;

import com.google.inject.Inject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.commands.SubCommand;
import org.reprogle.dimensionpause.utils.DimensionState;
import org.reprogle.dimensionpause.utils.InstantParser;

public class Toggle
implements SubCommand {
    @Inject
    CommandFeedback commandFeedback;
    @Inject
    DimensionState state;

    @Override
    public String getName() {
        return "toggle";
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (args.length >= 3 && (args[2].equalsIgnoreCase("end") || args[2].equalsIgnoreCase("nether"))) {
            String dimension;
            World world = Bukkit.getWorld((String)args[1]);
            if (world == null) {
                sender.sendMessage(this.commandFeedback.sendCommandFeedback("usage", null, null));
                return;
            }
            Instant pauseExpiration = null;
            if (args.length >= 4) {
                try {
                    pauseExpiration = InstantParser.parseFutureInstant(args[3]);
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(this.commandFeedback.sendCommandFeedback("usage", null, null));
                    return;
                }
            }
            World.Environment environment = (dimension = args[2].toLowerCase()).equalsIgnoreCase("nether") ? World.Environment.NETHER : World.Environment.THE_END;
            this.state.setDimensionState(world, environment, pauseExpiration);
            sender.sendMessage(this.commandFeedback.sendCommandFeedback("newstate", world, dimension));
        } else {
            sender.sendMessage(this.commandFeedback.sendCommandFeedback("usage", null, null));
        }
    }

    @Override
    public List<String> getSubcommands(CommandSender sender, String[] args) {
        ArrayList<String> subcommands = new ArrayList<String>();
        if (args.length == 2) {
            Bukkit.getWorlds().forEach(world -> {
                if (world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
                    subcommands.add(world.getName());
                }
            });
        } else if (args.length == 3) {
            subcommands.add("nether");
            subcommands.add("end");
        }
        return subcommands;
    }

    @Override
    public List<String> getRequiredPermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("dimensionpause.toggle");
        return permissions;
    }
}

