/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Instant;
import java.util.Collection;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.store.Database;
import org.reprogle.dimensionpause.store.SQLite;
import org.reprogle.dimensionpause.utils.ConfigManager;
import org.reprogle.dimensionpause.utils.DimensionExpirationTimer;

@Singleton
public class DimensionState {
    @Inject
    private ConfigManager configManager;
    @Inject
    private DimensionPausePlugin plugin;
    @Inject
    private CommandFeedback commandFeedback;
    @Inject
    private SQLite db;
    @Inject
    DimensionExpirationTimer timer;

    public void setDimensionState(World world, World.Environment dimension) {
        this.setDimensionState(world, dimension, null, State.TOGGLE);
    }

    public void setDimensionState(World world, World.Environment dimension, State state) {
        this.setDimensionState(world, dimension, null, state);
    }

    public void setDimensionState(World world, World.Environment dimension, @Nullable Instant expirationTime) {
        this.setDimensionState(world, dimension, expirationTime, expirationTime == null ? State.TOGGLE : State.DISABLED);
    }

    public void setDimensionState(World world, World.Environment dimension, @Nullable Instant expirationTime, State state) {
        boolean worldDimensionEnabled;
        Collection players = this.plugin.getServer().getOnlinePlayers();
        String worldName = world.getName();
        switch (state.ordinal()) {
            case 1: {
                worldDimensionEnabled = this.db.setWorld(worldName, dimension, false, expirationTime).enabled();
                break;
            }
            case 0: {
                worldDimensionEnabled = this.db.setWorld(worldName, dimension, true, expirationTime).enabled();
                break;
            }
            default: {
                worldDimensionEnabled = this.db.isWorldEnabled(worldName, dimension).enabled();
                worldDimensionEnabled = this.db.setWorld(worldName, dimension, !worldDimensionEnabled, expirationTime).enabled();
            }
        }
        this.timer.refresh();
        this.alertOfStateChange(players, worldName, dimension, worldDimensionEnabled);
        if (!worldDimensionEnabled) {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getWorld().getEnvironment().equals((Object)dimension) || this.canBypass(player, world, dimension)) continue;
                this.kickToWorld(player, dimension);
            }
        }
    }

    public void kickToWorld(Player player, World.Environment dimension) {
        Location loc = player.getRespawnLocation();
        if (this.configManager.getPluginConfig().getBoolean("try-bed-first").booleanValue() && loc != null) {
            player.teleportAsync(loc);
        } else {
            World world = Bukkit.getWorld((String)this.configManager.getPluginConfig().getString("kick-world"));
            if (world == null) {
                this.plugin.getLogger().log(Level.WARNING, "IMPORTANT MESSAGE! A world has been paused, but at least one player is still in it ({0}). This player doesn't have a valid respawn location, and the kick-world configured in config was not obtainable, so we cannot teleport players out of the world. Please intervene!", player.getName());
                return;
            }
            player.teleportAsync(world.getSpawnLocation());
        }
        this.alertPlayer(player, dimension);
    }

    public Database.WorldPauseStatus getState(World world, World.Environment dimension) {
        return this.getState(world.getName(), dimension);
    }

    public Database.WorldPauseStatus getState(String world, World.Environment dimension) {
        return this.db.isWorldEnabled(world, dimension);
    }

    public boolean canBypass(Player player, World world, World.Environment toEnvironment) {
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission("dimensionpause.*")) {
            return true;
        }
        return player.hasPermission("dimensionpause.bypass." + world.getName() + "." + (toEnvironment.equals((Object)World.Environment.NETHER) ? "nether" : "end"));
    }

    public void alertPlayer(Player player, World.Environment dimension) {
        String env = dimension.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        boolean sendTitle = this.configManager.getPluginConfig().getBoolean("dimensions." + env + ".alert.title");
        boolean sendChat = this.configManager.getPluginConfig().getBoolean("dimensions." + env + ".alert.chat");
        if (sendTitle) {
            player.showTitle(this.commandFeedback.getTitleForDimension(dimension));
        }
        if (sendChat) {
            player.sendMessage(this.commandFeedback.getDimensionIsPausedMessage(dimension));
        }
    }

    private void alertOfStateChange(Collection<? extends Player> players, String world, World.Environment environment, boolean newState) {
        String env;
        String string = env = environment.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        if (!this.configManager.getPluginConfig().getBoolean("dimensions." + env + ".alert.on-toggle").booleanValue()) {
            return;
        }
        for (Player player : players) {
            player.sendMessage(this.commandFeedback.getStateChangedMessage(world, environment, newState));
        }
    }

    public static enum State {
        ENABLED,
        DISABLED,
        TOGGLE;

    }
}

