/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.reprogle.dimensionpause.DimensionPausePlugin;

public abstract class Database {
    private static final String WORLD_TABLE = "dimensionpause_worlds";
    private static final String SELECT = "SELECT enabled, expiresAt FROM ";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String WHERE = " WHERE world = ? AND dimension = ? LIMIT 1;";
    final DimensionPausePlugin plugin;
    Connection connection;

    protected Database(DimensionPausePlugin plugin) {
        this.plugin = plugin;
    }

    public abstract Connection getSQLConnection();

    public WorldPauseStatus setWorld(String world, World.Environment dimension, boolean enabled, @Nullable Instant expiresAt) {
        try (Connection c = this.getSQLConnection();
             PreparedStatement ps = c.prepareStatement("INSERT INTO dimensionpause_worlds (world, dimension, enabled, updatedAt, expiresAt) VALUES (?, ?, ?, datetime('now'), ?) ON CONFLICT(world, dimension) DO UPDATE SET enabled = excluded.enabled, updatedAt = datetime('now'), expiresAt = CASE   WHEN excluded.expiresAt IS NOT NULL THEN excluded.expiresAt   WHEN excluded.enabled = 1 THEN NULL   ELSE expiresAt END");){
            try {
                ps.setString(1, world);
                ps.setString(2, dimension.toString());
                ps.setInt(3, enabled ? 1 : 0);
                if (expiresAt != null) {
                    ps.setLong(4, expiresAt.toEpochMilli());
                } else {
                    ps.setNull(4, -5);
                }
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error while executing create SQL statement: " + String.valueOf(e));
                this.plugin.getLogger().severe(Arrays.toString(e.getStackTrace()));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to close SQL Database connection: " + String.valueOf(e));
        }
        return new WorldPauseStatus(enabled, expiresAt);
    }

    /*
     * Exception decompiling
     */
    public WorldPauseStatus isWorldEnabled(String world, World.Environment dimension) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public record WorldPauseStatus(boolean enabled, Instant expiresAt) {
    }
}

