/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.store.Database;
import org.reprogle.dimensionpause.utils.ConfigManager;
import org.reprogle.dimensionpause.utils.DimensionState;

public class PlayerPortalEventListener
implements Listener {
    @Inject
    ConfigManager configManager;
    @Inject
    CommandFeedback commandFeedback;
    @Inject
    DimensionState state;
    @Inject
    DimensionPausePlugin plugin;
    private final Set<UUID> playersBeingHandled = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPortalEnter(PlayerPortalEvent event) {
        if (event.getPlayer().getWorld().getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        Player player = event.getPlayer();
        World.Environment environmentTo = event.getTo().getWorld().getEnvironment();
        String stringifiedEnv = environmentTo == World.Environment.NETHER ? "nether" : "end";
        Database.WorldPauseStatus status = this.state.getState(player.getWorld(), environmentTo);
        if (status.enabled()) {
            return;
        }
        if (this.state.canBypass(player, player.getWorld(), environmentTo)) {
            return;
        }
        event.setCancelled(true);
        if (this.configManager.getPluginConfig().getBoolean("dimensions." + stringifiedEnv + ".bounce-back").booleanValue()) {
            switch (environmentTo) {
                case NETHER: {
                    this.netherBounceback(player, event.getFrom());
                    break;
                }
                case THE_END: {
                    this.endBounceback(player);
                    break;
                }
            }
        }
        boolean sendTitle = this.configManager.getPluginConfig().getBoolean("dimensions." + stringifiedEnv + ".alert.title");
        boolean sendChat = this.configManager.getPluginConfig().getBoolean("dimensions." + stringifiedEnv + ".alert.chat");
        if (sendTitle) {
            player.showTitle(this.commandFeedback.getTitleForDimension(environmentTo));
        }
        if (sendChat) {
            player.sendMessage(this.commandFeedback.getDimensionIsPausedMessage(environmentTo));
        }
    }

    private void netherBounceback(Player player, Location portalLocation) {
        double newVecZ;
        double newVecX;
        if (this.playersBeingHandled.contains(player.getUniqueId())) {
            return;
        }
        this.playersBeingHandled.add(player.getUniqueId());
        double strength = 1.3;
        Block block = portalLocation.getBlock();
        if (block.getRelative(BlockFace.WEST).getType() == Material.NETHER_PORTAL || block.getRelative(BlockFace.EAST).getType() == Material.NETHER_PORTAL) {
            newVecX = 0.0;
            newVecZ = player.getLocation().getZ() < block.getLocation().getZ() + 0.5 ? -1.0 * strength : 1.0 * strength;
        } else {
            newVecZ = 0.0;
            newVecX = player.getLocation().getX() < block.getLocation().getX() + 0.5 ? -1.0 * strength : 1.0 * strength;
        }
        player.setVelocity(new Vector(newVecX, 0.5, newVecZ));
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 200, 5, false, false));
            this.playersBeingHandled.remove(player.getUniqueId());
        }, 1L);
    }

    private void endBounceback(Player player) {
        if (this.playersBeingHandled.contains(player.getUniqueId())) {
            return;
        }
        this.playersBeingHandled.add(player.getUniqueId());
        float yaw = player.getLocation().getYaw();
        double radians = Math.toRadians(yaw);
        double x = Math.sin(radians);
        double z = -Math.cos(radians);
        Vector knockbackDirection = new Vector(x, 0.7, z);
        knockbackDirection.multiply(0.9);
        player.setVelocity(knockbackDirection);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 200, 5, false, false));
            this.playersBeingHandled.remove(player.getUniqueId());
        }, 5L);
    }

    @EventHandler
    public void onPlayerDamageEvent(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (this.playersBeingHandled.contains(p.getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

