/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause;

import com.google.inject.Inject;
import com.google.inject.Injector;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.reprogle.dimensionpause.DPMetrics;
import org.reprogle.dimensionpause.DimensionPauseModule;
import org.reprogle.dimensionpause.UpdateChecker;
import org.reprogle.dimensionpause.commands.CommandManager;
import org.reprogle.dimensionpause.events.ListenerManager;
import org.reprogle.dimensionpause.utils.ConfigManager;
import org.reprogle.dimensionpause.utils.DimensionExpirationTimer;

public final class DimensionPausePlugin
extends JavaPlugin {
    @Inject
    ListenerManager listenerManager;
    @Inject
    CommandManager commandManager;
    @Inject
    DimensionExpirationTimer timer;
    private Injector injector;

    public void onLoad() {
        ConfigManager configManager = new ConfigManager();
        DimensionPauseModule module = new DimensionPauseModule(this, configManager);
        this.injector = module.createInjector();
        this.injector.injectMembers((Object)this);
    }

    public void onEnable() {
        new DPMetrics(this);
        this.getCommand("dimensionpause").setExecutor((CommandExecutor)this.commandManager);
        this.listenerManager.setupListeners();
        this.getLogger().info("Dimension Pause has been loaded");
        if (this.getDescription().getVersion().contains("SNAPSHOT")) {
            TextComponent updateMessage = Component.text((String)"You are running a SNAPSHOT version of DimensionPause. Support will not be provided!", (TextColor)NamedTextColor.RED);
            this.getServer().getConsoleSender().sendMessage((Component)updateMessage);
        } else {
            new UpdateChecker((Plugin)this, "https://raw.githubusercontent.com/TerrorByteTW/DimensionPause/master/version.txt").getVersion(latest -> {
                if (Integer.parseInt(latest.replace(".", "")) > Integer.parseInt(this.getDescription().getVersion().replace(".", ""))) {
                    this.getServer().getConsoleSender().sendMessage((Component)Component.text((String)("There is a new update available for DimensionPause: " + latest + ". Please download for the latest features and security updates!"), (TextColor)NamedTextColor.RED));
                } else {
                    this.getServer().getConsoleSender().sendMessage((Component)Component.text((String)"You are on the latest version of DimensionPause!", (TextColor)NamedTextColor.GREEN));
                }
            });
        }
        if (this.isFolia()) {
            this.getServer().getConsoleSender().sendMessage((Component)Component.text((String)"Welcome to Folia!!!! It is assumed you know what you're doing, since Folia is not yet standard. While DimensionPause can run on Folia, it is not yet officially endorsed by the developer, and is also not actively tested. Be wary when using it for now, and report any bugs in Honeypot caused by Folia to the developer!"));
        }
        this.timer.refresh();
    }

    public void onDisable() {
        this.getLogger().info("Dimension Pause is shutting down");
    }

    private boolean isFolia() {
        return Bukkit.getServer().getName().startsWith("Folia");
    }

    @Generated
    public Injector getInjector() {
        return this.injector;
    }
}

