/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.reprogle.dimensionpause.DimensionPausePlugin;

public abstract class Database {
    private static final String WORLD_TABLE = "dimensionpause_worlds";
    private static final String SELECT = "SELECT enabled, expiresAt FROM ";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String WHERE = " WHERE world = ? AND dimension = ? LIMIT 1;";
    final DimensionPausePlugin plugin;
    Connection connection;

    protected Database(DimensionPausePlugin plugin) {
        this.plugin = plugin;
    }

    public abstract Connection getSQLConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorld(String world, World.Environment dimension, boolean enabled, @Nullable LocalDate expiresAt) {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("INSERT INTO dimensionpause_worlds (world, dimension, enabled, updatedAt, expiresAt) VALUES (?, ?, ?, datetime('now'), ?) ON CONFLICT(world, dimension) DO UPDATE SET enabled = excluded.enabled, updatedAt = datetime('now'), expiresAt = CASE WHEN excluded.expiresAt IS NOT NULL THEN excluded.expiresAt WHEN excluded.enabled = 1 AND expiresAt IS NOT NULL AND expiresAt <= datetime('now') THEN NULL ELSE expiresAt END");
            ps.setString(1, world);
            ps.setString(2, dimension.toString());
            ps.setInt(3, enabled ? 1 : 0);
            ps.setObject(4, expiresAt);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error while executing create SQL statement on block table: " + String.valueOf(e));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to close SQL Database connection: " + String.valueOf(e));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public WorldPauseStatus isWorldEnabled(String world, World.Environment dimension) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public record WorldPauseStatus(boolean enabled, LocalDateTime expiresAt) {
    }
}

