/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import com.google.inject.Inject;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionState;

public class PlayerTeleportEventListener
implements Listener {
    @Inject
    ConfigManager configManager;
    @Inject
    DimensionState state;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getFrom().getWorld().equals((Object)event.getTo().getWorld())) {
            return;
        }
        World.Environment env = event.getTo().getWorld().getEnvironment();
        Player p = event.getPlayer();
        if (env.equals((Object)World.Environment.NORMAL)) {
            return;
        }
        boolean netherBypass = this.configManager.getPluginConfig().getBoolean("dimensions.nether.bypassable");
        boolean endBypass = this.configManager.getPluginConfig().getBoolean("dimensions.end.bypassable");
        if (!this.state.getState(event.getTo().getWorld(), env).enabled()) {
            if (this.state.canBypass(p, env.equals((Object)World.Environment.NETHER) ? netherBypass : endBypass)) {
                return;
            }
            event.setCancelled(true);
            this.state.alertPlayer(p, env);
        }
    }
}

