/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import com.google.inject.Inject;
import io.papermc.paper.event.player.AsyncPlayerSpawnLocationEvent;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.DimensionState;

public class PlayerSpawnLocationEventListener
implements Listener {
    @Inject
    private ConfigManager configManager;
    @Inject
    private DimensionState state;
    @Inject
    private DimensionPausePlugin plugin;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSpawn(AsyncPlayerSpawnLocationEvent event) {
        if (event.isNewPlayer()) {
            return;
        }
        World world = event.getSpawnLocation().getWorld();
        String kickWorld = this.configManager.getPluginConfig().getString("kick-world");
        if (world.getName().equals(kickWorld)) {
            return;
        }
        boolean netherBypass = this.configManager.getPluginConfig().getBoolean("dimensions.nether.bypassable");
        boolean endBypass = this.configManager.getPluginConfig().getBoolean("dimensions.end.bypassable");
        if (!this.state.getState(world, world.getEnvironment()).enabled()) {
            UUID playerUuid = event.getConnection().getProfile().getId();
            Player player = Bukkit.getPlayer((UUID)event.getConnection().getProfile().getId());
            if (playerUuid == null || player == null) {
                this.plugin.getLogger().warning("A player just spawned but their profile could not be retrieved, so we cannot check if they're allowed in this world or not. Check the above logs for the spawn event!");
                return;
            }
            if (this.state.canBypass(player, world.getEnvironment().equals((Object)World.Environment.NETHER) ? netherBypass : endBypass)) {
                return;
            }
            Location location = this.state.kickToWorld(player, world.getEnvironment(), false);
            if (location != null) {
                event.setSpawnLocation(location);
                this.state.alertPlayers.add(playerUuid);
            }
        }
    }
}

