/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.commands.SubCommand;

@Singleton
public class CommandManager
implements TabExecutor {
    private final CommandFeedback commandFeedback;
    @Inject
    private Set<SubCommand> subcommands;

    @Inject
    public CommandManager(CommandFeedback commandFeedback) {
        this.commandFeedback = commandFeedback;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!sender.hasPermission("dimensionpause.commands")) {
            sender.sendMessage(this.commandFeedback.sendCommandFeedback("nopermission", null, null));
            return false;
        }
        if (args.length > 0) {
            for (SubCommand subcommand : this.subcommands) {
                if (!args[0].equalsIgnoreCase(subcommand.getName())) continue;
                if (!this.checkPermissions(sender, subcommand)) {
                    sender.sendMessage(this.commandFeedback.sendCommandFeedback("nopermission", null, null));
                    return false;
                }
                subcommand.perform(sender, args);
                return true;
            }
            sender.sendMessage(this.commandFeedback.sendCommandFeedback("usage", null, null));
        } else {
            sender.sendMessage(this.commandFeedback.sendCommandFeedback("usage", null, null));
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!sender.hasPermission("dimensionpause.commands") && !sender.isOp()) {
            return null;
        }
        if (args.length == 1) {
            ArrayList<String> subcommandsTabComplete = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], List.of((String[])this.subcommands.stream().map(SubCommand::getName).toArray(String[]::new)), subcommandsTabComplete);
            return subcommandsTabComplete;
        }
        if (args.length >= 2) {
            for (SubCommand subcommand : this.subcommands) {
                if (!args[0].equalsIgnoreCase(subcommand.getName())) continue;
                ArrayList<String> subcommandsTabComplete = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[args.length - 1], subcommand.getSubcommands(sender, args), subcommandsTabComplete);
                return subcommandsTabComplete;
            }
        }
        return null;
    }

    private boolean checkPermissions(CommandSender sender, SubCommand subcommand) {
        boolean allowed = false;
        if (subcommand.getRequiredPermissions().isEmpty()) {
            return true;
        }
        for (String permission : subcommand.getRequiredPermissions()) {
            if (!sender.hasPermission(permission)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    @Generated
    public Set<SubCommand> getSubcommands() {
        return this.subcommands;
    }
}

